/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.wsutil.client.SAMLAttributePushOutHandler;
import eu.unicore.security.wsutil.client.WSClientFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.endpoint.Client;

public class ClientVOUtil {
    public static void addVOAssertion(Object xfireProxy, Assertion assertion) throws IOException {
        ClientVOUtil.addVOAssertions(xfireProxy, Collections.singletonList(assertion));
    }

    public static void addVOAssertion(Client xfireClient, Assertion assertion) throws IOException {
        ClientVOUtil.addVOAssertions(xfireClient, Collections.singletonList(assertion));
    }

    public static void addVOAssertions(Object xfireProxy, List<Assertion> assertions) throws IOException {
        Client xfireClient = WSClientFactory.getWSClient(xfireProxy);
        ClientVOUtil.addVOAssertions(xfireClient, assertions);
    }

    public static void addVOAssertions(Client wsClient, List<Assertion> assertions) throws IOException {
        List outHandlers = wsClient.getOutInterceptors();
        SAMLAttributePushOutHandler voHandler = null;
        for (Object h : outHandlers) {
            if (!(h instanceof SAMLAttributePushOutHandler)) continue;
            voHandler = (SAMLAttributePushOutHandler)h;
            break;
        }
        if (voHandler != null) {
            outHandlers.remove(voHandler);
        }
        voHandler = new SAMLAttributePushOutHandler(assertions);
        wsClient.getOutInterceptors().add(voHandler);
    }

    public static void removeVOHandlers(Object wsProxy) {
        Client wsClient = WSClientFactory.getWSClient(wsProxy);
        ClientVOUtil.removeVOHandlers(wsClient);
    }

    public static void removeVOHandlers(Client wsClient) {
        List outHandlers = wsClient.getOutInterceptors();
        for (int i = outHandlers.size() - 1; i >= 0; --i) {
            Object h = outHandlers.get(i);
            if (!(h instanceof SAMLAttributePushOutHandler)) continue;
            outHandlers.remove(i);
        }
    }

    public static List<Assertion> getConfiguredVOAssertions(Object wsProxy) throws IOException {
        Client wsClient = WSClientFactory.getWSClient(wsProxy);
        return ClientVOUtil.getConfiguredVOAssertions(wsClient);
    }

    public static List<Assertion> getConfiguredVOAssertions(Client wsClient) {
        List outHandlers = wsClient.getOutInterceptors();
        for (int i = outHandlers.size() - 1; i >= 0; --i) {
            Object h = outHandlers.get(i);
            if (!(h instanceof SAMLAttributePushOutHandler)) continue;
            return ((SAMLAttributePushOutHandler)h).getOrigList();
        }
        return null;
    }
}

