/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.security.etd.DelegationRestrictions;
import eu.unicore.security.etd.TrustDelegation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class ETDClientSettings
implements Cloneable {
    private String requestedUser;
    private Map<String, String[]> requestedAttributes = new HashMap<String, String[]>();
    private X500Principal receiver;
    private boolean extendTrustDelegation;
    private List<TrustDelegation> trustDelegationTokens;
    private X509Certificate[] issuerCertificateChain;
    private DelegationRestrictions delegationRestrictions = new DelegationRestrictions(null, null, 10);
    private Integer relativeDelegationValidityDays = 30;
    public static final String SAML_ATTRIBUTE_REQUEST_NAMEFORMAT = "urn:unicore:subject-requested-attribute";

    public void setRequestedUser(String requestedUserDN) {
        this.requestedUser = requestedUserDN;
    }

    public String getRequestedUser() {
        return this.requestedUser;
    }

    public Map<String, String[]> getRequestedUserAttributes2() {
        return this.requestedAttributes;
    }

    public X500Principal getReceiver() {
        return this.receiver;
    }

    public void setReceiver(X500Principal receiver) {
        this.receiver = receiver;
    }

    public boolean isExtendTrustDelegation() {
        return this.extendTrustDelegation;
    }

    public void setExtendTrustDelegation(boolean value) {
        this.extendTrustDelegation = value;
    }

    public List<TrustDelegation> getTrustDelegationTokens() {
        return this.trustDelegationTokens;
    }

    public void setTrustDelegationTokens(List<TrustDelegation> tdTokens) {
        this.trustDelegationTokens = tdTokens;
    }

    public X509Certificate[] getIssuerCertificateChain() {
        return this.issuerCertificateChain;
    }

    public void setIssuerCertificateChain(X509Certificate[] certChain) {
        this.issuerCertificateChain = certChain;
    }

    public void setDelegationRestrictions(DelegationRestrictions delegationRestrictions) {
        this.delegationRestrictions = delegationRestrictions;
    }

    public DelegationRestrictions getDelegationRestrictions() {
        return this.delegationRestrictions;
    }

    public void setRelativeDelegationValidityDays(Integer relativeDelegationValidityDays) {
        this.relativeDelegationValidityDays = relativeDelegationValidityDays;
    }

    public Integer getRelativeDelegationValidityDays() {
        return this.relativeDelegationValidityDays;
    }

    public void initializeSimple(X500Principal delegationReceiver, X509Credential issuer) {
        String requestedUserDN = issuer.getCertificate().getSubjectX500Principal().getName();
        this.setRequestedUser(requestedUserDN);
        this.setReceiver(delegationReceiver);
        this.setExtendTrustDelegation(true);
        this.setIssuerCertificateChain(issuer.getCertificateChain());
    }

    public ETDClientSettings clone() {
        ETDClientSettings copy = new ETDClientSettings();
        copy.extendTrustDelegation = this.extendTrustDelegation;
        if (this.issuerCertificateChain != null) {
            copy.issuerCertificateChain = (X509Certificate[])this.issuerCertificateChain.clone();
        }
        copy.receiver = this.receiver;
        copy.requestedAttributes.putAll(this.requestedAttributes);
        copy.requestedUser = this.requestedUser;
        if (this.trustDelegationTokens != null) {
            copy.trustDelegationTokens = new ArrayList<TrustDelegation>();
            copy.trustDelegationTokens.addAll(this.trustDelegationTokens);
        }
        copy.relativeDelegationValidityDays = this.relativeDelegationValidityDays;
        copy.delegationRestrictions = this.delegationRestrictions.clone();
        return copy;
    }
}

