/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.queryparser;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassMappingAware;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.SearchEngineFactoryAware;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.queryparser.DefaultLuceneQueryParser;
import org.compass.core.lucene.engine.queryparser.LuceneQueryParser;
import org.compass.core.lucene.engine.spellcheck.queryparser.SpellCheckLuceneQueryParser;
import org.compass.core.util.ClassUtils;

public class LuceneQueryParserManager
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(LuceneQueryParserManager.class);
    private HashMap<String, LuceneQueryParser> queryParsers = new HashMap();
    private LuceneSearchEngineFactory searchEngineFactory;

    public LuceneQueryParserManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        DefaultLuceneQueryParser queryParser;
        CompassSettings defaultGroupSettings = null;
        Map<String, CompassSettings> queryParserSettingGroups = settings.getSettingGroups("compass.engine.queryParser");
        for (Map.Entry<String, CompassSettings> entry : queryParserSettingGroups.entrySet()) {
            LuceneQueryParser queryParser2;
            Object queryParserType;
            String queryParserName = entry.getKey();
            CompassSettings queryParserSettings = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building query parser [" + queryParserName + "] with settings " + queryParserSettings));
            }
            if (queryParserName.equals("default")) {
                defaultGroupSettings = queryParserSettings;
            }
            if ((queryParserType = queryParserSettings.getSettingAsObject("type")) == null) {
                if (queryParserName.equals("default")) continue;
                throw new ConfigurationException("Failed to locate query parser [" + queryParserName + "] type, it must be set");
            }
            if (queryParserType instanceof LuceneQueryParser) {
                queryParser2 = (LuceneQueryParser)queryParserType;
            } else {
                try {
                    queryParser2 = (LuceneQueryParser)ClassUtils.forName((String)queryParserType, settings.getClassLoader()).newInstance();
                }
                catch (Exception e) {
                    throw new ConfigurationException("Failed to create query parser class [" + queryParserType + "]", e);
                }
            }
            if (queryParser2 instanceof CompassConfigurable) {
                ((CompassConfigurable)((Object)queryParser2)).configure(queryParserSettings);
            }
            if (queryParser2 instanceof CompassMappingAware) {
                ((CompassMappingAware)((Object)queryParser2)).setCompassMapping(this.searchEngineFactory.getMapping());
            }
            if (queryParser2 instanceof SearchEngineFactoryAware) {
                ((SearchEngineFactoryAware)((Object)queryParser2)).setSearchEngineFactory(this.searchEngineFactory);
            }
            this.queryParsers.put(queryParserName, queryParser2);
        }
        if (defaultGroupSettings == null) {
            defaultGroupSettings = new CompassSettings(settings.getClassLoader());
        }
        if (this.queryParsers.get("default") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No default query parser found (under groupd [default]), registering a default one");
            }
            queryParser = new DefaultLuceneQueryParser();
            queryParser.configure(defaultGroupSettings);
            queryParser.setCompassMapping(this.searchEngineFactory.getMapping());
            queryParser.setSearchEngineFactory(this.searchEngineFactory);
            this.queryParsers.put("default", queryParser);
        }
        if (this.searchEngineFactory.getSpellCheckManager() != null && this.queryParsers.get("spellcheck") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No spellcheck query parser found (under groupd [spellcheck]), registering a default one");
            }
            queryParser = new SpellCheckLuceneQueryParser();
            queryParser.configure(defaultGroupSettings);
            queryParser.setCompassMapping(this.searchEngineFactory.getMapping());
            queryParser.setSearchEngineFactory(this.searchEngineFactory);
            this.queryParsers.put("spellcheck", queryParser);
        }
    }

    public LuceneQueryParser getDefaultQueryParser() {
        return this.getQueryParser("default");
    }

    public LuceneQueryParser getQueryParser(String queryParserName) throws IllegalArgumentException {
        LuceneQueryParser queryParser = this.queryParsers.get(queryParserName);
        if (queryParser == null) {
            throw new IllegalArgumentException("No query parser is configured under [" + queryParserName + "]");
        }
        return queryParser;
    }
}

