/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core;

import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.credential.store.store.impl.CredentialReaderImpl;
import org.apache.airavata.gfac.core.GFacConstants;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GroovyMap;
import org.apache.airavata.gfac.core.JobManagerConfiguration;
import org.apache.airavata.gfac.core.Script;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataProductType;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.model.data.replica.ReplicaLocationCategory;
import org.apache.airavata.model.data.replica.ReplicaPersistentType;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.job.JobModel;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.messaging.event.JobStatusChangeEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessIdentifier;
import org.apache.airavata.model.messaging.event.ProcessStatusChangeEvent;
import org.apache.airavata.model.messaging.event.TaskIdentifier;
import org.apache.airavata.model.messaging.event.TaskStatusChangeEvent;
import org.apache.airavata.model.parallelism.ApplicationParallelismType;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.JobStatus;
import org.apache.airavata.model.status.ProcessState;
import org.apache.airavata.model.status.ProcessStatus;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.JobSubmissionTaskModel;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.GwyResourceProfile;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ReplicaCatalog;
import org.apache.commons.io.FileUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.utils.ZKPaths;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GFacUtils {
    private static final Logger log = LoggerFactory.getLogger(GFacUtils.class);
    public static final ArrayList<ACL> OPEN_ACL_UNSAFE = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    private GFacUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromStream(InputStream in) throws IOException {
        try {
            int read;
            StringBuffer wsdlStr = new StringBuffer();
            byte[] buf = new byte[1024];
            while ((read = in.read(buf)) > 0) {
                wsdlStr.append(new String(buf, 0, read));
            }
            String string = wsdlStr.toString();
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.warn("Cannot close InputStream: " + in.getClass().getName(), (Throwable)e);
                }
            }
        }
    }

    public static String maxWallTimeCalculator(int maxWalltime) {
        if (maxWalltime < 60) {
            return "00:" + maxWalltime + ":00";
        }
        int minutes = maxWalltime % 60;
        int hours = maxWalltime / 60;
        return hours + ":" + minutes + ":00";
    }

    public static String maxWallTimeCalculatorForLSF(int maxWalltime) {
        if (maxWalltime < 60) {
            return "00:" + maxWalltime;
        }
        int minutes = maxWalltime % 60;
        int hours = maxWalltime / 60;
        return hours + ":" + minutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String file) throws FileNotFoundException, IOException {
        BufferedReader instream = null;
        try {
            instream = new BufferedReader(new FileReader(file));
            StringBuffer buff = new StringBuffer();
            String temp = null;
            while ((temp = instream.readLine()) != null) {
                buff.append(temp);
                buff.append(GFacConstants.NEWLINE);
            }
            String string = buff.toString();
            return string;
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    log.warn("Cannot close FileinputStream", (Throwable)e);
                }
            }
        }
    }

    public static boolean isLocalHost(String appHost) throws UnknownHostException {
        String localHost = InetAddress.getLocalHost().getCanonicalHostName();
        return localHost.equals(appHost) || "localhost".equals(appHost) || "127.0.0.1".equals(appHost);
    }

    public static String createUniqueNameWithDate(String name) {
        String date = new Date().toString();
        date = date.replaceAll(" ", "_");
        date = date.replaceAll(":", "_");
        return name + "_" + date;
    }

    public static List<Element> getElementList(Document doc, String expression) throws XPathExpressionException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression expr = xPath.compile(expression);
        NodeList nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (!(item instanceof Element)) continue;
            elementList.add((Element)item);
        }
        return elementList;
    }

    public static String createGsiftpURIAsString(String host, String localPath) throws URISyntaxException {
        StringBuffer buf = new StringBuffer();
        if (!host.startsWith("gsiftp://")) {
            buf.append("gsiftp://");
        }
        buf.append(host);
        if (!host.endsWith("/")) {
            buf.append("/");
        }
        buf.append(localPath);
        return buf.toString();
    }

    public static void saveJobStatus(ProcessContext processContext, JobModel jobModel) throws GFacException {
        try {
            JobStatus jobStatus = null;
            if (jobModel.getJobStatuses() != null) {
                jobStatus = (JobStatus)jobModel.getJobStatuses().get(0);
            }
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            ArrayList<JobStatus> statuses = new ArrayList<JobStatus>();
            statuses.add(jobStatus);
            jobModel.setJobStatuses(statuses);
            if (jobStatus.getTimeOfStateChange() == 0L || jobStatus.getTimeOfStateChange() > 0L) {
                jobStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            } else {
                jobStatus.setTimeOfStateChange(jobStatus.getTimeOfStateChange());
            }
            CompositeIdentifier ids = new CompositeIdentifier((Object)jobModel.getTaskId(), (Object)jobModel.getJobId());
            experimentCatalog.add(ExpCatChildDataType.JOB_STATUS, (Object)jobStatus, (Object)ids);
            JobIdentifier identifier = new JobIdentifier(jobModel.getJobId(), jobModel.getTaskId(), processContext.getProcessId(), processContext.getProcessModel().getExperimentId(), processContext.getGatewayId());
            JobStatusChangeEvent jobStatusChangeEvent = new JobStatusChangeEvent(jobStatus.getJobState(), identifier);
            MessageContext msgCtx = new MessageContext((TBase)jobStatusChangeEvent, MessageType.JOB, AiravataUtils.getId((String)MessageType.JOB.name()), processContext.getGatewayId());
            msgCtx.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            processContext.getStatusPublisher().publish(msgCtx);
        }
        catch (Exception e) {
            throw new GFacException("Error persisting job status" + e.getLocalizedMessage(), e);
        }
    }

    public static void saveAndPublishTaskStatus(TaskContext taskContext) throws GFacException {
        try {
            TaskState state = taskContext.getTaskState();
            ProcessContext processContext = taskContext.getParentProcessContext();
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            TaskStatus status = taskContext.getTaskStatus();
            if (status.getTimeOfStateChange() == 0L || status.getTimeOfStateChange() > 0L) {
                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            } else {
                status.setTimeOfStateChange(status.getTimeOfStateChange());
            }
            experimentCatalog.add(ExpCatChildDataType.TASK_STATUS, (Object)status, (Object)taskContext.getTaskId());
            TaskIdentifier identifier = new TaskIdentifier(taskContext.getTaskId(), processContext.getProcessId(), processContext.getProcessModel().getExperimentId(), processContext.getGatewayId());
            TaskStatusChangeEvent taskStatusChangeEvent = new TaskStatusChangeEvent(state, identifier);
            MessageContext msgCtx = new MessageContext((TBase)taskStatusChangeEvent, MessageType.TASK, AiravataUtils.getId((String)MessageType.TASK.name()), taskContext.getParentProcessContext().getGatewayId());
            msgCtx.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            processContext.getStatusPublisher().publish(msgCtx);
        }
        catch (Exception e) {
            throw new GFacException("Error persisting task status" + e.getLocalizedMessage(), e);
        }
    }

    public static void saveAndPublishProcessStatus(ProcessContext processContext) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            ProcessStatus status = processContext.getProcessStatus();
            if (status.getTimeOfStateChange() == 0L || status.getTimeOfStateChange() > 0L) {
                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            } else {
                status.setTimeOfStateChange(status.getTimeOfStateChange());
            }
            experimentCatalog.add(ExpCatChildDataType.PROCESS_STATUS, (Object)status, (Object)processContext.getProcessId());
            ProcessIdentifier identifier = new ProcessIdentifier(processContext.getProcessId(), processContext.getProcessModel().getExperimentId(), processContext.getGatewayId());
            ProcessStatusChangeEvent processStatusChangeEvent = new ProcessStatusChangeEvent(status.getState(), identifier);
            MessageContext msgCtx = new MessageContext((TBase)processStatusChangeEvent, MessageType.PROCESS, AiravataUtils.getId((String)MessageType.PROCESS.name()), processContext.getGatewayId());
            msgCtx.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
            processContext.getStatusPublisher().publish(msgCtx);
        }
        catch (Exception e) {
            throw new GFacException("Error persisting process status" + e.getLocalizedMessage(), e);
        }
    }

    private static void removeCancelDeliveryTagNode(String experimentPath, CuratorFramework curatorClient) throws Exception {
        Stat exists = (Stat)curatorClient.checkExists().forPath(experimentPath + "-cancel-deliveryTag");
        if (exists != null) {
            ZKPaths.deleteChildren((ZooKeeper)curatorClient.getZookeeperClient().getZooKeeper(), (String)(experimentPath + "-cancel-deliveryTag"), (boolean)true);
        }
    }

    private static void copyChildren(CuratorFramework curatorClient, String oldPath, String newPath, int depth) throws Exception {
        for (String childNode : (List)curatorClient.getChildren().forPath(oldPath)) {
            String oldChildPath = oldPath + File.separator + childNode;
            Stat stat = (Stat)curatorClient.checkExists().forPath(oldChildPath);
            String newChildPath = newPath + File.separator + childNode;
            log.info("Creating new znode: " + newChildPath);
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curatorClient.create().withMode(CreateMode.PERSISTENT)).withACL(OPEN_ACL_UNSAFE)).forPath(newChildPath, (byte[])((WatchPathable)curatorClient.getData().storingStatIn(stat)).forPath(oldChildPath));
            if (--depth <= 0) continue;
            GFacUtils.copyChildren(curatorClient, oldChildPath, newChildPath, depth);
        }
    }

    public static boolean setExperimentCancelRequest(String processId, CuratorFramework curatorClient, long deliveryTag) throws Exception {
        String experimentNode = ZKPaths.makePath((String)"/experiments", (String)processId);
        String cancelListenerNodePath = ZKPaths.makePath((String)experimentNode, (String)"/cancelListener");
        ((BackgroundPathAndBytesable)curatorClient.setData().withVersion(-1)).forPath(cancelListenerNodePath, "CANCEL_REQUEST".getBytes());
        return true;
    }

    public static CredentialReader getCredentialReader() throws ApplicationSettingsException, IllegalAccessException, InstantiationException {
        try {
            String jdbcUrl = ServerSettings.getCredentialStoreDBURL();
            String jdbcUsr = ServerSettings.getCredentialStoreDBUser();
            String jdbcPass = ServerSettings.getCredentialStoreDBPassword();
            String driver = ServerSettings.getCredentialStoreDBDriver();
            return new CredentialReaderImpl(new DBUtil(jdbcUrl, jdbcUsr, jdbcPass, driver));
        }
        catch (ClassNotFoundException e) {
            log.error("Not able to find driver: " + e.getLocalizedMessage());
            return null;
        }
    }

    public static LOCALSubmission getLocalJobSubmission(String submissionId) throws AppCatalogException {
        try {
            AppCatalog appCatalog = RegistryFactory.getAppCatalog();
            return appCatalog.getComputeResource().getLocalJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving local job submission with submission id : " + submissionId;
            log.error(errorMsg, (Throwable)e);
            throw new AppCatalogException(errorMsg, (Throwable)e);
        }
    }

    public static UnicoreJobSubmission getUnicoreJobSubmission(String submissionId) throws AppCatalogException {
        try {
            AppCatalog appCatalog = RegistryFactory.getAppCatalog();
            return appCatalog.getComputeResource().getUNICOREJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving UNICORE job submission with submission id : " + submissionId;
            log.error(errorMsg, (Throwable)e);
            throw new AppCatalogException(errorMsg, (Throwable)e);
        }
    }

    public static SSHJobSubmission getSSHJobSubmission(String submissionId) throws AppCatalogException {
        try {
            AppCatalog appCatalog = RegistryFactory.getAppCatalog();
            return appCatalog.getComputeResource().getSSHJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SSH job submission with submission id : " + submissionId;
            log.error(errorMsg, (Throwable)e);
            throw new AppCatalogException(errorMsg, (Throwable)e);
        }
    }

    public static CloudJobSubmission getCloudJobSubmission(String submissionId) throws RegistryException {
        try {
            AppCatalog appCatalog = RegistryFactory.getAppCatalog();
            return appCatalog.getComputeResource().getCloudJobSubmission(submissionId);
        }
        catch (Exception e) {
            String errorMsg = "Error while retrieving SSH job submission with submission id : " + submissionId;
            log.error(errorMsg, (Throwable)e);
            throw new RegistryException(errorMsg, (Throwable)e);
        }
    }

    public static String listToCsv(List<String> listOfStrings, char separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listOfStrings.size() - 1; ++i) {
            sb.append(listOfStrings.get(i));
            sb.append(separator);
        }
        if (listOfStrings.size() > 0) {
            sb.append(listOfStrings.get(listOfStrings.size() - 1));
        }
        return sb.toString();
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static String getZKGfacServersParentPath() {
        return ZKPaths.makePath((String)"/servers", (String)"/gfac");
    }

    public static GroovyMap crateGroovyMap(ProcessContext processContext) throws ApplicationSettingsException, AppCatalogException, GFacException {
        return GFacUtils.createGroovyMap(processContext, null);
    }

    public static GroovyMap createGroovyMap(ProcessContext processContext, TaskContext taskContext) throws GFacException, AppCatalogException, ApplicationSettingsException {
        Map parallelismPrefix;
        ApplicationParallelismType parallelism;
        List postJobCommands;
        List preJobCommands;
        ComputationalResourceSchedulingModel scheduling;
        String qoS;
        GroovyMap groovyMap = new GroovyMap();
        ProcessModel processModel = processContext.getProcessModel();
        ResourceJobManager resourceJobManager = GFacUtils.getResourceJobManager(processContext);
        GFacUtils.setMailAddresses(processContext, groovyMap);
        groovyMap.add(Script.INPUT_DIR, processContext.getInputDir());
        groovyMap.add(Script.OUTPUT_DIR, processContext.getOutputDir());
        groovyMap.add(Script.EXECUTABLE_PATH, processContext.getApplicationDeploymentDescription().getExecutablePath());
        groovyMap.add(Script.STANDARD_OUT_FILE, processContext.getStdoutLocation());
        groovyMap.add(Script.STANDARD_ERROR_FILE, processContext.getStderrLocation());
        groovyMap.add(Script.SCRATCH_LOCATION, processContext.getScratchLocation());
        groovyMap.add(Script.GATEWAY_ID, processContext.getGatewayId());
        groovyMap.add(Script.GATEWAY_USER_NAME, processContext.getProcessModel().getUserName());
        groovyMap.add(Script.APPLICATION_NAME, processContext.getApplicationInterfaceDescription().getApplicationName());
        groovyMap.add(Script.QUEUE_SPECIFIC_MACROS, processContext.getQueueSpecificMacros());
        groovyMap.add(Script.ACCOUNT_STRING, processContext.getAllocationProjectNumber());
        groovyMap.add(Script.RESERVATION, processContext.getReservation());
        groovyMap.add(Script.JOB_NAME, "A" + String.valueOf(GFacUtils.generateJobName()));
        groovyMap.add(Script.WORKING_DIR, processContext.getWorkingDir());
        List<String> inputValues = GFacUtils.getProcessInputValues(processModel.getProcessInputs());
        inputValues.addAll(GFacUtils.getProcessOutputValues(processModel.getProcessOutputs()));
        groovyMap.add(Script.INPUTS, inputValues);
        groovyMap.add(Script.EXPERIMENT_DATA_DIR, processModel.getExperimentDataDir());
        groovyMap.add(Script.USER_NAME, processContext.getJobSubmissionRemoteCluster().getServerInfo().getUserName());
        groovyMap.add(Script.SHELL_NAME, "/bin/bash");
        if (taskContext != null) {
            try {
                JobSubmissionTaskModel jobSubmissionTaskModel = (JobSubmissionTaskModel)taskContext.getSubTaskModel();
                if (jobSubmissionTaskModel.getWallTime() > 0) {
                    groovyMap.add(Script.MAX_WALL_TIME, GFacUtils.maxWallTimeCalculator(jobSubmissionTaskModel.getWallTime()));
                    if (resourceJobManager != null && resourceJobManager.getResourceJobManagerType().equals((Object)ResourceJobManagerType.LSF)) {
                        groovyMap.add(Script.MAX_WALL_TIME, GFacUtils.maxWallTimeCalculatorForLSF(jobSubmissionTaskModel.getWallTime()));
                    }
                }
            }
            catch (TException e) {
                log.error("Error while getting job submission sub task model", (Throwable)e);
            }
        }
        if ((qoS = GFacUtils.getQoS(processContext.getQualityOfService(), processContext.getQueueName())) != null) {
            groovyMap.add(Script.QUALITY_OF_SERVICE, qoS);
        }
        if ((scheduling = processModel.getProcessResourceSchedule()) != null) {
            int totalNodeCount = scheduling.getNodeCount();
            int totalCPUCount = scheduling.getTotalCPUCount();
            if (GFacUtils.isValid(scheduling.getQueueName())) {
                groovyMap.add(Script.QUEUE_NAME, scheduling.getQueueName());
            }
            if (totalNodeCount > 0) {
                groovyMap.add(Script.NODES, totalNodeCount);
            }
            if (totalCPUCount > 0) {
                int ppn = totalCPUCount / totalNodeCount;
                groovyMap.add(Script.PROCESS_PER_NODE, ppn);
                groovyMap.add(Script.CPU_COUNT, totalCPUCount);
            }
            if (scheduling.getWallTimeLimit() > 0 && groovyMap.get(Script.MAX_WALL_TIME) == null) {
                groovyMap.add(Script.MAX_WALL_TIME, GFacUtils.maxWallTimeCalculator(scheduling.getWallTimeLimit()));
                if (resourceJobManager != null && resourceJobManager.getResourceJobManagerType().equals((Object)ResourceJobManagerType.LSF)) {
                    groovyMap.add(Script.MAX_WALL_TIME, GFacUtils.maxWallTimeCalculatorForLSF(scheduling.getWallTimeLimit()));
                }
            }
            if (scheduling.getTotalPhysicalMemory() > 0) {
                groovyMap.add(Script.USED_MEM, scheduling.getTotalPhysicalMemory());
            }
            if (GFacUtils.isValid(scheduling.getOverrideLoginUserName())) {
                groovyMap.add(Script.USER_NAME, scheduling.getOverrideLoginUserName());
            }
            if (GFacUtils.isValid(scheduling.getOverrideAllocationProjectNumber())) {
                groovyMap.add(Script.ACCOUNT_STRING, scheduling.getOverrideAllocationProjectNumber());
            }
            if (GFacUtils.isValid(scheduling.getStaticWorkingDir())) {
                groovyMap.add(Script.WORKING_DIR, scheduling.getStaticWorkingDir());
            }
        } else {
            log.error("Task scheduling cannot be null at this point..");
        }
        ApplicationDeploymentDescription appDepDescription = processContext.getApplicationDeploymentDescription();
        List moduleCmds = appDepDescription.getModuleLoadCmds();
        if (moduleCmds != null) {
            List modulesCmdCollect = moduleCmds.stream().sorted((e1, e2) -> e1.getCommandOrder() - e2.getCommandOrder()).map(map -> map.getCommand()).collect(Collectors.toList());
            groovyMap.add(Script.MODULE_COMMANDS, modulesCmdCollect);
        }
        if ((preJobCommands = appDepDescription.getPreJobCommands()) != null) {
            List preJobCmdCollect = preJobCommands.stream().sorted((e1, e2) -> e1.getCommandOrder() - e2.getCommandOrder()).map(map -> GFacUtils.parseCommands(map.getCommand(), groovyMap)).collect(Collectors.toList());
            groovyMap.add(Script.PRE_JOB_COMMANDS, preJobCmdCollect);
        }
        if ((postJobCommands = appDepDescription.getPostJobCommands()) != null) {
            List postJobCmdCollect = postJobCommands.stream().sorted((e1, e2) -> e1.getCommandOrder() - e2.getCommandOrder()).map(map -> GFacUtils.parseCommands(map.getCommand(), groovyMap)).collect(Collectors.toList());
            groovyMap.add(Script.POST_JOB_COMMANDS, postJobCmdCollect);
        }
        if ((parallelism = appDepDescription.getParallelism()) != null && parallelism != ApplicationParallelismType.SERIAL && (parallelismPrefix = processContext.getResourceJobManager().getParallelismPrefix()) != null) {
            String parallelismCommand = (String)parallelismPrefix.get(parallelism);
            if (parallelismCommand != null) {
                groovyMap.add(Script.JOB_SUBMITTER_COMMAND, parallelismCommand);
            } else {
                throw new GFacException("Parallelism prefix is not defined for given parallelism type " + parallelism + ".. Please define the parallelism prefix at App Catalog");
            }
        }
        return groovyMap;
    }

    private static boolean isValid(String str) {
        return str != null && !str.isEmpty();
    }

    private static void setMailAddresses(ProcessContext processContext, GroovyMap groovyMap) throws GFacException, AppCatalogException, ApplicationSettingsException {
        ProcessModel processModel = processContext.getProcessModel();
        String emailIds = null;
        if (GFacUtils.isEmailBasedJobMonitor(processContext)) {
            emailIds = ServerSettings.getEmailBasedMonitorAddress();
        }
        if (ServerSettings.getSetting((String)"job.notification.enable").equalsIgnoreCase("true")) {
            List emailList;
            String elist;
            String userJobNotifEmailIds = ServerSettings.getSetting((String)"job.notification.emailids");
            if (userJobNotifEmailIds != null && !userJobNotifEmailIds.isEmpty()) {
                emailIds = emailIds != null && !emailIds.isEmpty() ? emailIds + "," + userJobNotifEmailIds : userJobNotifEmailIds;
            }
            if (processModel.isEnableEmailNotification() && (elist = GFacUtils.listToCsv(emailList = processModel.getEmailAddresses(), ',')) != null && !elist.isEmpty()) {
                emailIds = emailIds != null && !emailIds.isEmpty() ? emailIds + "," + elist : elist;
            }
        }
        if (emailIds != null && !emailIds.isEmpty()) {
            log.info("Email list: " + emailIds);
            groovyMap.add(Script.MAIL_ADDRESS, emailIds);
        }
    }

    private static List<String> getProcessOutputValues(List<OutputDataObjectType> processOutputs) {
        ArrayList<String> inputValues = new ArrayList<String>();
        if (processOutputs != null) {
            for (OutputDataObjectType output : processOutputs) {
                if (output.getApplicationArgument() != null && !output.getApplicationArgument().equals("")) {
                    inputValues.add(output.getApplicationArgument());
                }
                if (output.getValue() == null || output.getValue().equals("") || !output.isRequiredToAddedToCommandLine() || output.getType() != DataType.URI) continue;
                String filePath = output.getValue();
                filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, filePath.length());
                inputValues.add(filePath);
            }
        }
        return inputValues;
    }

    private static List<String> getProcessInputValues(List<InputDataObjectType> processInputs) {
        ArrayList<String> inputValues = new ArrayList<String>();
        if (processInputs != null) {
            Comparator<InputDataObjectType> inputOrderComparator = new Comparator<InputDataObjectType>(){

                @Override
                public int compare(InputDataObjectType inputDataObjectType, InputDataObjectType t1) {
                    return inputDataObjectType.getInputOrder() - t1.getInputOrder();
                }
            };
            TreeSet<InputDataObjectType> sortedInputSet = new TreeSet<InputDataObjectType>(inputOrderComparator);
            for (InputDataObjectType input : processInputs) {
                sortedInputSet.add(input);
            }
            for (InputDataObjectType inputDataObjectType : sortedInputSet) {
                if (!inputDataObjectType.isRequiredToAddedToCommandLine()) continue;
                if (inputDataObjectType.getApplicationArgument() != null && !inputDataObjectType.getApplicationArgument().equals("")) {
                    inputValues.add(inputDataObjectType.getApplicationArgument());
                }
                if (inputDataObjectType.getValue() == null || inputDataObjectType.getValue().equals("")) continue;
                if (inputDataObjectType.getType() == DataType.URI) {
                    String filePath = inputDataObjectType.getValue();
                    filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, filePath.length());
                    inputValues.add(filePath);
                    continue;
                }
                if (inputDataObjectType.getType() == DataType.URI_COLLECTION) {
                    int i;
                    String filePaths = inputDataObjectType.getValue();
                    String[] paths = filePaths.split(",");
                    String inputs = "";
                    for (i = 0; i < paths.length - 1; ++i) {
                        String filePath = paths[i];
                        filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, filePath.length());
                        inputs = inputs + filePath + " ";
                    }
                    inputs = inputs + paths[i];
                    inputValues.add(inputs);
                    continue;
                }
                inputValues.add(inputDataObjectType.getValue());
            }
        }
        return inputValues;
    }

    static String getQoS(String qualityOfService, String preferredBatchQueue) {
        if (preferredBatchQueue == null || preferredBatchQueue.isEmpty() || qualityOfService == null || qualityOfService.isEmpty()) {
            return null;
        }
        String qos = "qos";
        Pattern pattern = Pattern.compile(preferredBatchQueue + "=(?<" + "qos" + ">[^,]*)");
        Matcher matcher = pattern.matcher(qualityOfService);
        if (matcher.find()) {
            return matcher.group("qos");
        }
        return null;
    }

    public static int generateJobName() {
        Random random = new Random();
        int i = random.nextInt(Integer.MAX_VALUE);
        if ((i += 99999999) < 0) {
            i *= -1;
        }
        return i;
    }

    static String parseCommands(String value, GroovyMap bindMap) {
        GStringTemplateEngine templateEngine = new GStringTemplateEngine();
        try {
            return templateEngine.createTemplate(value).make((Map)bindMap).toString();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("Error while parsing command " + value + " , Invalid command or incomplete bind map");
        }
    }

    public static ResourceJobManager getResourceJobManager(ProcessContext processContext) {
        try {
            SSHJobSubmission sshJobSubmission;
            JobSubmissionProtocol submissionProtocol = GFacUtils.getPreferredJobSubmissionProtocol(processContext);
            JobSubmissionInterface jobSubmissionInterface = GFacUtils.getPreferredJobSubmissionInterface(processContext);
            if (submissionProtocol == JobSubmissionProtocol.SSH) {
                SSHJobSubmission sshJobSubmission2 = GFacUtils.getSSHJobSubmission(jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (sshJobSubmission2 != null) {
                    return sshJobSubmission2.getResourceJobManager();
                }
            } else if (submissionProtocol == JobSubmissionProtocol.LOCAL) {
                LOCALSubmission localJobSubmission = GFacUtils.getLocalJobSubmission(jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (localJobSubmission != null) {
                    return localJobSubmission.getResourceJobManager();
                }
            } else if (submissionProtocol == JobSubmissionProtocol.SSH_FORK && (sshJobSubmission = GFacUtils.getSSHJobSubmission(jobSubmissionInterface.getJobSubmissionInterfaceId())) != null) {
                return sshJobSubmission.getResourceJobManager();
            }
        }
        catch (AppCatalogException e) {
            log.error("Error occured while retrieving resource job manager", (Throwable)e);
        }
        return null;
    }

    public static boolean isEmailBasedJobMonitor(ProcessContext processContext) throws GFacException, AppCatalogException {
        JobSubmissionProtocol jobSubmissionProtocol = GFacUtils.getPreferredJobSubmissionProtocol(processContext);
        JobSubmissionInterface jobSubmissionInterface = GFacUtils.getPreferredJobSubmissionInterface(processContext);
        if (jobSubmissionProtocol == JobSubmissionProtocol.SSH) {
            String jobSubmissionInterfaceId = jobSubmissionInterface.getJobSubmissionInterfaceId();
            SSHJobSubmission sshJobSubmission = processContext.getAppCatalog().getComputeResource().getSSHJobSubmission(jobSubmissionInterfaceId);
            MonitorMode monitorMode = sshJobSubmission.getMonitorMode();
            return monitorMode != null && monitorMode == MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR;
        }
        return false;
    }

    public static JobSubmissionInterface getPreferredJobSubmissionInterface(ProcessContext processContext) throws AppCatalogException {
        try {
            String resourceHostId = processContext.getComputeResourceDescription().getComputeResourceId();
            JobSubmissionProtocol preferredJobSubmissionProtocol = processContext.getPreferredJobSubmissionProtocol();
            ComputeResourceDescription resourceDescription = processContext.getAppCatalog().getComputeResource().getComputeResource(resourceHostId);
            List jobSubmissionInterfaces = resourceDescription.getJobSubmissionInterfaces();
            HashMap<JobSubmissionProtocol, List<JobSubmissionInterface>> orderedInterfaces = new HashMap<JobSubmissionProtocol, List<JobSubmissionInterface>>();
            List<JobSubmissionInterface> interfaces = new ArrayList();
            if (jobSubmissionInterfaces != null && !jobSubmissionInterfaces.isEmpty()) {
                for (JobSubmissionInterface submissionInterface : jobSubmissionInterfaces) {
                    if (preferredJobSubmissionProtocol != null) {
                        if (!preferredJobSubmissionProtocol.toString().equals(submissionInterface.getJobSubmissionProtocol().toString())) continue;
                        if (orderedInterfaces.containsKey(submissionInterface.getJobSubmissionProtocol())) {
                            List interfaceList = (List)orderedInterfaces.get(submissionInterface.getJobSubmissionProtocol());
                            interfaceList.add(submissionInterface);
                            continue;
                        }
                        interfaces.add(submissionInterface);
                        orderedInterfaces.put(submissionInterface.getJobSubmissionProtocol(), interfaces);
                        continue;
                    }
                    Collections.sort(jobSubmissionInterfaces, new Comparator<JobSubmissionInterface>(){

                        @Override
                        public int compare(JobSubmissionInterface jobSubmissionInterface, JobSubmissionInterface jobSubmissionInterface2) {
                            return jobSubmissionInterface.getPriorityOrder() - jobSubmissionInterface2.getPriorityOrder();
                        }
                    });
                }
            } else {
                throw new AppCatalogException("Compute resource should have at least one job submission interface defined...");
            }
            interfaces = (List)orderedInterfaces.get(preferredJobSubmissionProtocol);
            Collections.sort(interfaces, new Comparator<JobSubmissionInterface>(){

                @Override
                public int compare(JobSubmissionInterface jobSubmissionInterface, JobSubmissionInterface jobSubmissionInterface2) {
                    return jobSubmissionInterface.getPriorityOrder() - jobSubmissionInterface2.getPriorityOrder();
                }
            });
            return (JobSubmissionInterface)interfaces.get(0);
        }
        catch (AppCatalogException e) {
            throw new AppCatalogException("Error occurred while retrieving data from app catalog", (Throwable)e);
        }
    }

    public static JobSubmissionProtocol getPreferredJobSubmissionProtocol(ProcessContext context) throws AppCatalogException {
        try {
            GwyResourceProfile gatewayProfile = context.getAppCatalog().getGatewayProfile();
            String resourceHostId = context.getComputeResourceDescription().getComputeResourceId();
            ComputeResourcePreference preference = gatewayProfile.getComputeResourcePreference(context.getGatewayId(), resourceHostId);
            return preference.getPreferredJobSubmissionProtocol();
        }
        catch (AppCatalogException e) {
            log.error("Error occurred while initializing app catalog", (Throwable)e);
            throw new AppCatalogException("Error occurred while initializing app catalog", (Throwable)e);
        }
    }

    public static File createJobFile(GroovyMap groovyMap, TaskContext tc, JobManagerConfiguration jMC) throws GFacException {
        try {
            int number = new SecureRandom().nextInt();
            number = number < 0 ? -number : number;
            File tempJobFile = new File(GFacUtils.getLocalDataDir(tc), "job_" + Integer.toString(number) + jMC.getScriptExtension());
            FileUtils.writeStringToFile((File)tempJobFile, (String)GFacUtils.generateScript(groovyMap, jMC.getJobDescriptionTemplateName()));
            return tempJobFile;
        }
        catch (IOException e) {
            throw new GFacException("Error while writing script content to temp file");
        }
    }

    public static String generateScript(GroovyMap groovyMap, String templateName) throws GFacException {
        Writable make;
        URL templateUrl = ApplicationSettings.loadFile((String)templateName);
        if (templateUrl == null) {
            String error = "Template file '" + templateName + "' not found";
            throw new GFacException(error);
        }
        File template = new File(templateUrl.getPath());
        GStringTemplateEngine engine = new GStringTemplateEngine();
        try {
            make = engine.createTemplate(template).make((Map)groovyMap);
        }
        catch (Exception e) {
            throw new GFacException("Error while generating script using groovy map", e);
        }
        return make.toString();
    }

    public static String getTemplateFileName(ResourceJobManagerType resourceJobManagerType) {
        switch (resourceJobManagerType) {
            case FORK: {
                return "UGE_Groovy.template";
            }
            case PBS: {
                return "PBS_Groovy.template";
            }
            case SLURM: {
                return "SLURM_Groovy.template";
            }
            case UGE: {
                return "UGE_Groovy.template";
            }
            case LSF: {
                return "LSF_Groovy.template";
            }
            case CLOUD: {
                return "CLOUD_Groovy.template";
            }
        }
        return null;
    }

    public static File getLocalDataDir(TaskContext taskContext) {
        String outputPath = ServerSettings.getLocalDataLocation();
        outputPath = outputPath.endsWith(File.separator) ? outputPath : outputPath + File.separator;
        return new File(outputPath + taskContext.getParentProcessContext().getProcessId());
    }

    public static String getExperimentNodePath(String experimentId) {
        return ZKPaths.makePath((String)"/experiments", (String)experimentId);
    }

    public static long getProcessDeliveryTag(CuratorFramework curatorClient, String experimentId, String processId) throws Exception {
        String deliveryTagPath = ZKPaths.makePath((String)ZKPaths.makePath((String)GFacUtils.getExperimentNodePath(experimentId), (String)processId), (String)"/deliveryTag");
        Stat stat = (Stat)curatorClient.checkExists().forPath(deliveryTagPath);
        if (stat != null) {
            byte[] bytes = (byte[])curatorClient.getData().forPath(deliveryTagPath);
            return GFacUtils.bytesToLong(bytes);
        }
        throw new GFacException("Couldn't fine the deliveryTag path: " + deliveryTagPath);
    }

    public static void saveJobModel(ProcessContext processContext, JobModel jobModel) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            experimentCatalog.add(ExpCatChildDataType.JOB, (Object)jobModel, (Object)processContext.getProcessId());
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " jobId: " + jobModel.getJobId() + " : - Error while saving Job Model";
            throw new GFacException(msg, e);
        }
    }

    public static void saveExperimentInput(ProcessContext processContext, String inputName, String inputVal) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            String experimentId = processContext.getExperimentId();
            ExperimentModel experiment = (ExperimentModel)experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            List experimentInputs = experiment.getExperimentInputs();
            if (experimentInputs != null && !experimentInputs.isEmpty()) {
                for (InputDataObjectType expInput : experimentInputs) {
                    if (!expInput.getName().equals(inputName)) continue;
                    expInput.setValue(inputVal);
                }
            }
            experimentCatalog.update(ExperimentCatalogModelType.EXPERIMENT, (Object)experiment, (Object)experimentId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating experiment inputs";
            throw new GFacException(msg, e);
        }
    }

    public static void saveProcessInput(ProcessContext processContext, String inputName, String inputVal) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            String processId = processContext.getProcessId();
            ProcessModel processModel = (ProcessModel)experimentCatalog.get(ExperimentCatalogModelType.PROCESS, (Object)processId);
            List processInputs = processModel.getProcessInputs();
            if (processInputs != null && !processInputs.isEmpty()) {
                for (InputDataObjectType processInput : processInputs) {
                    if (!processInput.getName().equals(inputName)) continue;
                    processInput.setValue(inputVal);
                }
            }
            experimentCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating experiment inputs";
            throw new GFacException(msg, e);
        }
    }

    public static void saveExperimentOutput(ProcessContext processContext, String outputName, String outputVal) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            String experimentId = processContext.getExperimentId();
            ExperimentModel experiment = (ExperimentModel)experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            List experimentOutputs = experiment.getExperimentOutputs();
            if (experimentOutputs != null && !experimentOutputs.isEmpty()) {
                for (OutputDataObjectType expOutput : experimentOutputs) {
                    if (!expOutput.getName().equals(outputName)) continue;
                    if (expOutput.getType() == DataType.URI || expOutput.getType() == DataType.URI_COLLECTION || expOutput.getType() == DataType.STDERR || expOutput.getType() == DataType.STDOUT) {
                        DataProductModel dataProductModel = new DataProductModel();
                        dataProductModel.setGatewayId(processContext.getGatewayId());
                        dataProductModel.setOwnerName(processContext.getProcessModel().getUserName());
                        dataProductModel.setProductName(outputName);
                        dataProductModel.setDataProductType(DataProductType.FILE);
                        DataReplicaLocationModel replicaLocationModel = new DataReplicaLocationModel();
                        replicaLocationModel.setStorageResourceId(processContext.getStorageResource().getStorageResourceId());
                        replicaLocationModel.setReplicaName(outputName + " gateway data store copy");
                        replicaLocationModel.setReplicaLocationCategory(ReplicaLocationCategory.GATEWAY_DATA_STORE);
                        replicaLocationModel.setReplicaPersistentType(ReplicaPersistentType.TRANSIENT);
                        replicaLocationModel.setFilePath(outputVal);
                        dataProductModel.addToReplicaLocations(replicaLocationModel);
                        ReplicaCatalog replicaCatalog = RegistryFactory.getReplicaCatalog();
                        String productUri = replicaCatalog.registerDataProduct(dataProductModel);
                        expOutput.setValue(productUri);
                        continue;
                    }
                    if (expOutput.getType() != DataType.STRING && expOutput.getType() != DataType.INTEGER && expOutput.getType() != DataType.FLOAT) continue;
                    expOutput.setValue(outputVal);
                }
            }
            experimentCatalog.update(ExperimentCatalogModelType.EXPERIMENT, (Object)experiment, (Object)experimentId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating experiment outputs";
            throw new GFacException(msg, e);
        }
    }

    public static void saveProcessOutput(ProcessContext processContext, String outputName, String outputVal) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            String processId = processContext.getProcessId();
            List processOutputs = (List)experimentCatalog.get(ExperimentCatalogModelType.PROCESS_OUTPUT, (Object)processId);
            if (processOutputs != null && !processOutputs.isEmpty()) {
                for (OutputDataObjectType processOutput : processOutputs) {
                    if (!processOutput.getName().equals(outputName)) continue;
                    processOutput.setValue(outputVal);
                }
            }
            ProcessModel processModel = processContext.getProcessModel();
            processModel.setProcessOutputs(processOutputs);
            experimentCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating experiment outputs";
            throw new GFacException(msg, e);
        }
    }

    public static void saveExperimentError(ProcessContext processContext, ErrorModel errorModel) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            String experimentId = processContext.getExperimentId();
            errorModel.setErrorId(AiravataUtils.getId((String)"EXP_ERROR"));
            experimentCatalog.add(ExpCatChildDataType.EXPERIMENT_ERROR, (Object)errorModel, (Object)experimentId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating experiment errors";
            throw new GFacException(msg, e);
        }
    }

    public static void saveProcessError(ProcessContext processContext, ErrorModel errorModel) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
            errorModel.setErrorId(AiravataUtils.getId((String)"PROCESS_ERROR"));
            experimentCatalog.add(ExpCatChildDataType.PROCESS_ERROR, (Object)errorModel, (Object)processContext.getProcessId());
        }
        catch (RegistryException e) {
            String msg = "expId: " + processContext.getExperimentId() + " processId: " + processContext.getProcessId() + " : - Error while updating process errors";
            throw new GFacException(msg, e);
        }
    }

    public static void saveTaskError(TaskContext taskContext, ErrorModel errorModel) throws GFacException {
        try {
            ExperimentCatalog experimentCatalog = taskContext.getParentProcessContext().getExperimentCatalog();
            String taskId = taskContext.getTaskId();
            errorModel.setErrorId(AiravataUtils.getId((String)"TASK_ERROR"));
            experimentCatalog.add(ExpCatChildDataType.TASK_ERROR, (Object)errorModel, (Object)taskId);
        }
        catch (RegistryException e) {
            String msg = "expId: " + taskContext.getParentProcessContext().getExperimentId() + " processId: " + taskContext.getParentProcessContext().getProcessId() + " taskId: " + taskContext.getTaskId() + " : - Error while updating task errors";
            throw new GFacException(msg, e);
        }
    }

    public static void handleProcessInterrupt(ProcessContext processContext) throws GFacException {
        if (processContext.isCancel()) {
            ProcessStatus pStatus = new ProcessStatus(ProcessState.CANCELLING);
            pStatus.setReason("Process Cancel triggered");
            pStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            processContext.setProcessStatus(pStatus);
            GFacUtils.saveAndPublishProcessStatus(processContext);
            pStatus.setState(ProcessState.CANCELED);
            processContext.setProcessStatus(pStatus);
            pStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            GFacUtils.saveAndPublishProcessStatus(processContext);
        } else if (!processContext.isHandOver()) {
            log.error("expId: {}, processId: {} :- Unknown process interrupt", (Object)processContext.getExperimentId(), (Object)processContext.getProcessId());
        }
    }

    public static JobModel getJobModel(ProcessContext processContext) throws RegistryException {
        ExperimentCatalog experimentCatalog = processContext.getExperimentCatalog();
        List objects = experimentCatalog.get(ExperimentCatalogModelType.JOB, "processId", (Object)processContext.getProcessId());
        ArrayList jobModels = new ArrayList();
        JobModel jobModel = null;
        if (objects != null) {
            for (Object object : objects) {
                jobModel = (JobModel)object;
                if (jobModel.getJobId() == null && jobModel.equals((Object)"")) continue;
                return jobModel;
            }
        }
        return jobModel;
    }

    public static List<String> parseTaskDag(String taskDag) {
        String[] tasks = taskDag.split(",");
        return Arrays.asList(tasks);
    }
}

