/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.SecurityUtil;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.Gateway;
import org.apache.airavata.registry.core.experiment.catalog.model.UserPK;
import org.apache.airavata.registry.core.experiment.catalog.model.Users;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private String userName;
    private String password;
    private String gatewayId;

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ExpCatResourceUtils.getEntityManager();
            UserPK userPK = new UserPK();
            userPK.setGatewayId(this.gatewayId);
            userPK.setUserName(this.userName);
            Users existingUser = (Users)em.find(Users.class, (Object)userPK);
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayId);
            em.close();
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Users user = new Users();
            user.setAiravataInternalUserId(this.userName + "@" + this.gatewayId);
            user.setUserName(this.userName);
            user.setGatewayId(gateway.getGatewayId());
            user.setGateway(gateway);
            if (this.password != null && !this.password.equals("")) {
                try {
                    user.setPassword(SecurityUtil.digestString((String)this.password, (String)ServerSettings.getSetting((String)"default.registry.password.hash.method")));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Error hashing default admin password. Invalid hash algorithm.", e);
                }
                catch (ApplicationSettingsException e) {
                    throw new RuntimeException("Error reading hash algorithm from configurations", e);
                }
            }
            if (existingUser != null) {
                if (this.password != null && !this.password.equals("")) {
                    try {
                        existingUser.setPassword(SecurityUtil.digestString((String)this.password, (String)ServerSettings.getSetting((String)"default.registry.password.hash.method")));
                        existingUser.setGatewayId(gateway.getGatewayId());
                        existingUser.setGateway(gateway);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Error hashing default admin password. Invalid hash algorithm.", e);
                    }
                    catch (ApplicationSettingsException e) {
                        throw new RuntimeException("Error reading hash algorithm from configurations", e);
                    }
                }
                user = (Users)em.merge((Object)existingUser);
            } else {
                em.persist((Object)user);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

