/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity.mutation;

import java.util.Arrays;
import java.util.BitSet;
import org.hibernate.sql.model.TableMapping;

public final class TableSet {
    private BitSet bits;
    private Object[] checks;

    public void add(TableMapping tableMapping) {
        if (this.bits == null) {
            this.bits = new BitSet();
        }
        assert (this.addForChecks(tableMapping));
        this.bits.set(tableMapping.getRelativePosition());
    }

    public boolean isEmpty() {
        return this.bits == null;
    }

    public boolean contains(TableMapping tableMapping) {
        assert (this.matchRead(tableMapping));
        return this.bits != null && this.bits.get(tableMapping.getRelativePosition());
    }

    private boolean matchRead(TableMapping tableMapping) {
        int index;
        if (this.bits != null && this.bits.get(index = tableMapping.getRelativePosition())) {
            return this.checks[index] == tableMapping;
        }
        return true;
    }

    private boolean addForChecks(TableMapping tableMapping) {
        int position = tableMapping.getRelativePosition();
        this.ensureCapacity(position);
        if (this.checks[position] != null && this.checks[position] != tableMapping) {
            return false;
        }
        this.checks[position] = tableMapping;
        return true;
    }

    private void ensureCapacity(int position) {
        int increments = 3;
        if (this.checks == null) {
            this.checks = new Object[position + 3];
        } else if (this.checks.length <= position) {
            this.checks = Arrays.copyOf(this.checks, position + 3);
        }
    }
}

