/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.RestManagementConstants;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleExceptionSchema;
import org.apache.aries.jax.rs.rest.management.schema.BundleStartLevelSchema;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;

public class FrameworkBundleStartLevelResource
extends BaseResource {
    public FrameworkBundleStartLevelResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.bundlestartlevel+json", "application/org.osgi.bundlestartlevel+xml"})
    @Path(value="framework/bundle/{bundleid}/startlevel{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/bundle/startlevel", summary="Retrieves a Bundle Startlevel Representation from the REST management service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=BundleStartLevelSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response bundleStartlevel(@PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Bundle bundle = this.bundleContext.getBundle(bundleid);
        if (bundle == null) {
            throw new WebApplicationException(404);
        }
        Response.ResponseBuilder builder = Response.ok((Object)((Object)BundleStartLevelSchema.build((BundleStartLevelDTO)bundle.adapt(BundleStartLevelDTO.class))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundlestartlevel+json" : "application/org.osgi.bundlestartlevel+xml").map(type -> builder.type(type)).orElse(builder).build();
    }

    @PUT
    @Consumes(value={"application/org.osgi.bundlestartlevel+json", "application/org.osgi.bundlestartlevel+xml"})
    @Produces(value={"application/org.osgi.bundlestartlevel+json", "application/org.osgi.bundlestartlevel+xml"})
    @Path(value="framework/bundle/{bundleid}/startlevel{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="PUT/bundle/startlevel", summary="Sets the target bundle startlevel", responses={@ApiResponse(responseCode="200", description="The request was received and valid. The REST management service has changed the bundle startlevel according to the target value", content={@Content(schema=@Schema(implementation=BundleStartLevelSchema.class))}), @ApiResponse(responseCode="400", description="Either the target startlevel state involved invalid values, e.g., a startlevel smaller or equal to zero and the REST management service got an IllegalArgumentException, or the REST management service received a BundleException when trying to perform the startlevel change", content={@Content(mediaType="application/org.osgi.bundleexception+json", schema=@Schema(implementation=BundleExceptionSchema.class)), @Content(mediaType="application/org.osgi.bundleexception+xml", schema=@Schema(implementation=BundleExceptionSchema.class))}), @ApiResponse(responseCode="404", description="There is no bundle with the given bundle id"), @ApiResponse(responseCode="415", description="The request had a media type that is not supported by the REST management service")})
    public Response bundleStartlevel(BundleStartLevelSchema update, @PathParam(value="bundleid") long bundleid, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext, @HeaderParam(value="Content-Type") MediaType contentType) {
        Bundle bundle = this.bundleContext.getBundle(bundleid);
        if (bundle == null) {
            throw new WebApplicationException(404);
        }
        try {
            BundleStartLevel current = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            if (current.getStartLevel() != update.startLevel) {
                current.setStartLevel(update.startLevel);
            }
            Response.ResponseBuilder builder = Response.ok((Object)((Object)BundleStartLevelSchema.build((BundleStartLevelDTO)bundle.adapt(BundleStartLevelDTO.class))));
            return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.bundlestartlevel+json" : "application/org.osgi.bundlestartlevel+xml").map(type -> builder.type(type)).orElse(builder).build();
        }
        catch (Exception exception) {
            if (exception instanceof BundleException) {
                return Response.status((int)400).type(contentType.equals((Object)RestManagementConstants.APPLICATION_BUNDLESTARTLEVEL_JSON_TYPE) ? RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_JSON_TYPE : RestManagementConstants.APPLICATION_BUNDLEEXCEPTION_XML_TYPE).entity((Object)BundleExceptionSchema.build(((BundleException)((Object)exception)).getType(), exception.getMessage())).build();
            }
            throw new WebApplicationException((Throwable)exception, 400);
        }
    }
}

