/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.introspection;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.aries.jax.rs.whiteboard.internal.introspection.ClassIntrospector;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import test.types.PlainResource;
import test.types.PlainResourceSeveralOperations;
import test.types.PlainResourceSeveralOperationsCommonPath;
import test.types.PlainResourceSeveralOperationsDifferentPath;
import test.types.PlainResourceSeveralOperationsWithNameBinding;
import test.types.ResourceMethodInfoDTOWrapper;
import test.types.ResourceWithSubResource;

public class ClassIntrospectorTest {
    @Test
    public void testPlainResource() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(PlainResource.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)1, (int)resourceMethodInfoDTOS.length);
        ResourceMethodInfoDTO resourceMethodInfoDTO = resourceMethodInfoDTOS[0];
        Assertions.assertEquals((Object)"GET", (Object)resourceMethodInfoDTO.method);
        Assertions.assertNull((Object)resourceMethodInfoDTO.consumingMimeType);
        Assertions.assertNull((Object)resourceMethodInfoDTO.producingMimeType);
        Assertions.assertEquals((Object)"/", (Object)resourceMethodInfoDTO.path);
        Assertions.assertNull((Object)resourceMethodInfoDTO.nameBindings);
    }

    @Test
    public void testPlainResourceWithNameBinding() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(PlainResourceSeveralOperationsWithNameBinding.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)2, (int)resourceMethodInfoDTOS.length);
        List wrappers = Arrays.stream(resourceMethodInfoDTOS).map(ResourceMethodInfoDTOWrapper::new).collect(Collectors.toList());
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/";
        resourceMethodInfoDTO.nameBindings = new String[]{"test.types.Bound"};
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/";
        resourceMethodInfoDTO.nameBindings = new String[]{"test.types.Bound"};
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
    }

    @Test
    public void testPlainResourceSeveralOperations() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(PlainResourceSeveralOperations.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)2, (int)resourceMethodInfoDTOS.length);
        List wrappers = Arrays.stream(resourceMethodInfoDTOS).map(ResourceMethodInfoDTOWrapper::new).collect(Collectors.toList());
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
    }

    @Test
    public void testPlainResourceSeveralOperationsWithCommonPath() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(PlainResourceSeveralOperationsCommonPath.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)2, (int)resourceMethodInfoDTOS.length);
        List wrappers = Arrays.stream(resourceMethodInfoDTOS).map(ResourceMethodInfoDTOWrapper::new).collect(Collectors.toList());
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/common";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/common";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
    }

    @Test
    public void testPlainResourceSeveralOperationsWithDifferentPath() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(PlainResourceSeveralOperationsDifferentPath.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)2, (int)resourceMethodInfoDTOS.length);
        List wrappers = Arrays.stream(resourceMethodInfoDTOS).map(ResourceMethodInfoDTOWrapper::new).collect(Collectors.toList());
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/common";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = null;
        resourceMethodInfoDTO.path = "/common/different";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
    }

    @Test
    public void testResourceWithSubresource() {
        Bus bus = BusFactory.getDefaultBus((boolean)true);
        ResourceMethodInfoDTO[] resourceMethodInfoDTOS = ClassIntrospector.getResourceMethodInfos(ResourceWithSubResource.class, (Bus)bus).toArray(new ResourceMethodInfoDTO[0]);
        Assertions.assertEquals((int)5, (int)resourceMethodInfoDTOS.length);
        List wrappers = Arrays.stream(resourceMethodInfoDTOS).map(ResourceMethodInfoDTOWrapper::new).collect(Collectors.toList());
        ResourceMethodInfoDTO resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = null;
        resourceMethodInfoDTO.producingMimeType = new String[]{"application/xml"};
        resourceMethodInfoDTO.path = "/resource";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = new String[]{"application/json"};
        resourceMethodInfoDTO.producingMimeType = new String[]{"application/json"};
        resourceMethodInfoDTO.path = "/resource/subresource";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = new String[]{"application/xml"};
        resourceMethodInfoDTO.producingMimeType = new String[]{"text/plain", "application/json"};
        resourceMethodInfoDTO.path = "/resource/subresource";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "GET";
        resourceMethodInfoDTO.consumingMimeType = new String[]{"application/json"};
        resourceMethodInfoDTO.producingMimeType = new String[]{"application/json"};
        resourceMethodInfoDTO.path = "/resource/subresource/{path}";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        resourceMethodInfoDTO = new ResourceMethodInfoDTO();
        resourceMethodInfoDTO.method = "POST";
        resourceMethodInfoDTO.consumingMimeType = new String[]{"application/xml"};
        resourceMethodInfoDTO.producingMimeType = new String[]{"text/plain", "application/json"};
        resourceMethodInfoDTO.path = "/resource/subresource/{path}";
        resourceMethodInfoDTO.nameBindings = null;
        Assertions.assertTrue((boolean)wrappers.remove((Object)new ResourceMethodInfoDTOWrapper(resourceMethodInfoDTO)));
        Assertions.assertTrue((boolean)wrappers.isEmpty());
    }
}

