/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.fetcher.impl;

import com.rometools.fetcher.FeedFetcher;
import com.rometools.fetcher.FetcherEvent;
import com.rometools.fetcher.FetcherException;
import com.rometools.fetcher.FetcherListener;
import com.rometools.rome.feed.synd.SyndFeed;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractFeedFetcher
implements FeedFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFeedFetcher.class);
    private final Set<FetcherListener> listeners = Collections.synchronizedSet(new HashSet());
    private String userAgent;
    private boolean usingDeltaEncoding;
    private boolean preserveWireFeed;
    private boolean allowDoctypes = false;

    public AbstractFeedFetcher() {
        Properties props = new Properties(System.getProperties());
        String resourceName = "fetcher.properties";
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("fetcher.properties");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("fetcher.properties");
            }
            if (inputStream != null) {
                props.load(inputStream);
                System.getProperties().putAll((Map<?, ?>)props);
                inputStream.close();
            } else {
                LOG.warn("Could not find {} on classpath", (Object)"fetcher.properties");
            }
        }
        catch (IOException e) {
            LOG.error("Error reading {} from classpath: {}", (Object)"fetcher.properties", (Object)e.getMessage());
        }
        this.setUserAgent("Rome Client (http://tinyurl.com/64t5n) Ver: " + System.getProperty("rome.fetcher.version", "UNKNOWN"));
    }

    @Override
    public synchronized String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public synchronized void setUserAgent(String string) {
        this.userAgent = string;
    }

    protected void fireEvent(String eventType, URLConnection connection) {
        this.fireEvent(eventType, connection.getURL().toExternalForm(), null);
    }

    protected void fireEvent(String eventType, URLConnection connection, SyndFeed feed) {
        this.fireEvent(eventType, connection.getURL().toExternalForm(), feed);
    }

    protected void fireEvent(String eventType, String urlStr) {
        this.fireEvent(eventType, urlStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(String eventType, String urlStr, SyndFeed feed) {
        FetcherEvent fetcherEvent = new FetcherEvent(this, urlStr, eventType, feed);
        Set<FetcherListener> set = this.listeners;
        synchronized (set) {
            for (FetcherListener fetcherEventListener : this.listeners) {
                fetcherEventListener.fetcherEvent(fetcherEvent);
            }
        }
    }

    @Override
    public void addFetcherEventListener(FetcherListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeFetcherEventListener(FetcherListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public synchronized boolean isUsingDeltaEncoding() {
        return this.usingDeltaEncoding;
    }

    @Override
    public synchronized void setUsingDeltaEncoding(boolean useDeltaEncoding) {
        this.usingDeltaEncoding = useDeltaEncoding;
    }

    protected void handleErrorCodes(int responseCode) throws FetcherException {
        if (responseCode == 403) {
            this.throwAuthenticationError(responseCode);
        } else if (responseCode >= 400 && responseCode < 500) {
            this.throw4XXError(responseCode);
        } else if (responseCode >= 500 && responseCode < 600) {
            throw new FetcherException(responseCode, "The server encounted an error. HTTP Response code was:" + responseCode);
        }
    }

    protected void throw4XXError(int responseCode) throws FetcherException {
        throw new FetcherException(responseCode, "The requested resource could not be found. HTTP Response code was:" + responseCode);
    }

    protected void throwAuthenticationError(int responseCode) throws FetcherException {
        throw new FetcherException(responseCode, "Authentication required for that resource. HTTP Response code was:" + responseCode);
    }

    public static SyndFeed combineFeeds(SyndFeed originalFeed, SyndFeed newFeed) {
        try {
            SyndFeed result = (SyndFeed)newFeed.clone();
            result.getEntries().addAll(result.getEntries().size(), originalFeed.getEntries());
            return result;
        }
        catch (CloneNotSupportedException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot clone feed");
            iae.initCause(e);
            throw iae;
        }
    }

    public boolean isPreserveWireFeed() {
        return this.preserveWireFeed;
    }

    @Override
    public void setPreserveWireFeed(boolean preserveWireFeed) {
        this.preserveWireFeed = preserveWireFeed;
    }

    public boolean isAllowDoctypes() {
        return this.allowDoctypes;
    }

    @Override
    public void setAllowDoctypes(boolean allowDoctypes) {
        this.allowDoctypes = allowDoctypes;
    }
}

