/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IIoOperationFailedCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationSchedulerFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractAsynchronousScheduler;

public class GreedyScheduler
extends AbstractAsynchronousScheduler {
    public static final ILSMIOOperationSchedulerFactory FACTORY = new ILSMIOOperationSchedulerFactory(){

        @Override
        public ILSMIOOperationScheduler createIoScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback) {
            return new GreedyScheduler(threadFactory, callback);
        }

        @Override
        public String getName() {
            return "greedy";
        }
    };
    private final Map<String, List<ILSMIOOperation>> mergeOperations = new HashMap<String, List<ILSMIOOperation>>();

    public GreedyScheduler(ThreadFactory threadFactory, IIoOperationFailedCallback callback) {
        super(threadFactory, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scheduleMerge(ILSMIOOperation operation) {
        operation.pause();
        String id = operation.getIndexIdentifier();
        ExecutorService executorService = this.executor;
        synchronized (executorService) {
            List mergeOpList = this.mergeOperations.computeIfAbsent(id, key -> new ArrayList());
            mergeOpList.add(operation);
            this.dispatchMergeOperation(mergeOpList);
        }
        this.executor.submit(operation);
    }

    private void dispatchMergeOperation(List<ILSMIOOperation> mergeOps) {
        ILSMIOOperation activeOp = null;
        ILSMIOOperation smallestMergeOp = null;
        for (ILSMIOOperation op : mergeOps) {
            if (op.isActive()) {
                activeOp = op;
            }
            if (smallestMergeOp != null && op.getRemainingPages() >= smallestMergeOp.getRemainingPages()) continue;
            smallestMergeOp = op;
        }
        if (smallestMergeOp != activeOp) {
            if (activeOp != null) {
                activeOp.pause();
            }
            smallestMergeOp.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeOperation(ILSMIOOperation op) {
        if (op.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE) {
            String id = op.getIndexIdentifier();
            ExecutorService executorService = this.executor;
            synchronized (executorService) {
                List<ILSMIOOperation> mergeOpList = this.mergeOperations.get(id);
                mergeOpList.remove(op);
                if (!mergeOpList.isEmpty()) {
                    this.dispatchMergeOperation(mergeOpList);
                }
            }
        }
    }
}

