/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;

import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public final class JByte extends JObject<Byte> {

    public JByte(byte value) {
        super(new AMutableInt8(value));
    }

    public void setValue(byte v) {
        ((AMutableInt8) value).setValue(v);
    }

    public byte getValue() {
        return ((AMutableInt8) value).getByteValue();
    }

    @Override
    public Byte getValueGeneric() {
        return ((AMutableInt8) value).getByteValue();
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        serializeTypeTag(writeTypeTag, dataOutput, ATypeTag.TINYINT);
        AInt8SerializerDeserializer.INSTANCE.serialize((AInt8) value, dataOutput);
    }

    @Override
    public void reset() {
        ((AMutableInt8) value).setValue((byte) 0);
    }

    @Override
    public IAType getIAType() {
        return BuiltinType.AINT8;
    }

    @Override
    public void setValueGeneric(Byte o) {
        setValue(o);

    }
}
