/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.AbstractSqlppExpressionExtractionVisitor;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.CheckSql92AggregateVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppGroupByVisitor
extends AbstractSqlppExpressionExtractionVisitor {
    public SqlppGroupByVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        if (selectBlock.hasFromClause()) {
            if (selectBlock.hasGroupbyClause()) {
                this.rewriteSelectWithGroupBy(selectBlock, arg);
            } else {
                this.rewriteSelectWithoutGroupBy(selectBlock);
            }
        }
        return super.visit(selectBlock, arg);
    }

    private void rewriteSelectWithGroupBy(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        List<Object> groupFieldList;
        GroupbyClause gbyClause = selectBlock.getGroupbyClause();
        if (!gbyClause.hasGroupVar()) {
            VariableExpr groupVar = new VariableExpr(this.context.newVariable());
            groupVar.setSourceLocation(gbyClause.getSourceLocation());
            gbyClause.setGroupVar(groupVar);
        }
        if (gbyClause.hasGroupFieldList()) {
            groupFieldList = new ArrayList();
            for (Pair groupField : gbyClause.getGroupFieldList()) {
                Expression newFieldExpr = (Expression)((Expression)groupField.first).accept((ILangVisitor)this, (Object)arg);
                groupFieldList.add(new Pair((Object)newFieldExpr, (Object)((Identifier)groupField.second)));
            }
        } else {
            groupFieldList = this.createGroupFieldList(selectBlock);
        }
        gbyClause.setGroupFieldList(groupFieldList);
    }

    private void rewriteSelectWithoutGroupBy(SelectBlock selectBlock) throws CompilationException {
        if (this.hasSql92Aggregate(selectBlock)) {
            ArrayList gbyPairList = new ArrayList();
            ArrayList decorPairList = new ArrayList();
            VariableExpr groupVar = new VariableExpr(this.context.newVariable());
            groupVar.setSourceLocation(selectBlock.getSourceLocation());
            List<Pair<Expression, Identifier>> groupFieldList = this.createGroupFieldList(selectBlock);
            GroupbyClause gbyClause = new GroupbyClause(gbyPairList, decorPairList, new HashMap(), groupVar, groupFieldList, false, true);
            gbyClause.setSourceLocation(selectBlock.getSourceLocation());
            selectBlock.setGroupbyClause(gbyClause);
        }
    }

    private boolean hasSql92Aggregate(SelectBlock selectBlock) throws CompilationException {
        SelectClause selectClause = selectBlock.getSelectClause();
        if (selectClause.selectRegular()) {
            return this.isSql92Aggregate((ILangExpression)selectClause.getSelectRegular(), selectBlock);
        }
        if (selectClause.selectElement()) {
            return this.isSql92Aggregate((ILangExpression)selectClause.getSelectElement(), selectBlock);
        }
        throw new IllegalStateException();
    }

    private boolean isSql92Aggregate(ILangExpression expr, SelectBlock selectBlock) throws CompilationException {
        CheckSql92AggregateVisitor visitor = new CheckSql92AggregateVisitor();
        return (Boolean)expr.accept((ILangVisitor)visitor, (Object)selectBlock);
    }

    private List<Pair<Expression, Identifier>> createGroupFieldList(SelectBlock selectBlock) {
        ArrayList<Pair<Expression, Identifier>> groupFieldList = new ArrayList<Pair<Expression, Identifier>>();
        this.addToFieldList(groupFieldList, SqlppVariableUtil.getBindingVariables(selectBlock.getFromClause()));
        this.addToFieldList(groupFieldList, SqlppVariableUtil.getLetBindingVariables(selectBlock.getLetWhereList()));
        return groupFieldList;
    }

    private void addToFieldList(List<Pair<Expression, Identifier>> outFieldList, List<VariableExpr> varList) {
        for (VariableExpr varExpr : varList) {
            SqlppVariableUtil.addToFieldVariableList(varExpr, outFieldList);
        }
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        AbstractSqlppExpressionExtractionVisitor.StackElement stackElement;
        Expression resultExpr = super.visit(callExpr, arg);
        if (SqlppGroupByVisitor.isGroupingOperation(resultExpr) && (stackElement = (AbstractSqlppExpressionExtractionVisitor.StackElement)this.stack.peek()) != null && stackElement.getSelectBlock().hasGroupbyClause()) {
            VarIdentifier v = stackElement.addPendingLetClause(resultExpr);
            VariableExpr vExpr = new VariableExpr(v);
            vExpr.setSourceLocation(callExpr.getSourceLocation());
            resultExpr = vExpr;
        }
        return resultExpr;
    }

    static boolean isGroupingOperation(Expression expr) {
        if (expr.getKind() == Expression.Kind.CALL_EXPRESSION) {
            CallExpr callExpr = (CallExpr)expr;
            FunctionSignature fs = callExpr.getFunctionSignature();
            return BuiltinFunctions.GROUPING.getName().equalsIgnoreCase(fs.getName());
        }
        return false;
    }

    @Override
    void handleUnsupportedClause(FromClause clause) throws CompilationException {
        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_USE_OF_IDENTIFIER, clause.getSourceLocation(), new Serializable[]{BuiltinFunctions.GROUPING.getName()});
    }
}

