/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.usearnregion;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.services.s3.internal.usearnregion.UseArnRegionProvider;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class ProfileUseArnRegionProvider
implements UseArnRegionProvider {
    private static final String AWS_USE_ARN_REGION = "s3_use_arn_region";
    private Supplier<ProfileFile> profileFile;

    private ProfileUseArnRegionProvider(Supplier<ProfileFile> profileFile) {
        this.profileFile = profileFile;
    }

    public static ProfileUseArnRegionProvider create() {
        return new ProfileUseArnRegionProvider(ProfileFile::defaultProfileFile);
    }

    @Override
    public Optional<Boolean> resolveUseArnRegion() {
        return ProfileFileSystemSetting.AWS_CONFIG_FILE.getStringValue().flatMap(s -> this.profileFile.get().profile(ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow())).map(p -> (String)p.properties().get(AWS_USE_ARN_REGION)).map(StringUtils::safeStringToBoolean);
    }
}

