/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class KeyFieldTypeUtil {
    private KeyFieldTypeUtil() {
    }

    public static List<IAType> getPartitoningKeyTypes(Dataset dataset, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        if (dataset.getDatasetType() != DatasetConfig.DatasetType.INTERNAL) {
            return null;
        }
        InternalDatasetDetails datasetDetails = (InternalDatasetDetails)dataset.getDatasetDetails();
        return KeyFieldTypeUtil.getPartitioningKeyTypes(datasetDetails, recordType, metaRecordType);
    }

    public static List<IAType> getPartitioningKeyTypes(InternalDatasetDetails datasetDetails, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        List<Integer> keySourceIndicators = datasetDetails.getKeySourceIndicator();
        List<List<String>> partitioningKeys = datasetDetails.getPartitioningKey();
        return KeyFieldTypeUtil.getKeyTypes(recordType, metaRecordType, partitioningKeys, keySourceIndicators);
    }

    public static List<IAType> getKeyTypes(ARecordType recordType, ARecordType metaRecordType, List<List<String>> keys, List<Integer> keySourceIndicators) throws AlgebricksException {
        ArrayList<IAType> keyTypes = new ArrayList<IAType>();
        int index = 0;
        for (List<String> partitioningKey : keys) {
            keyTypes.add(KeyFieldTypeUtil.chooseSource(keySourceIndicators, index, recordType, metaRecordType).getSubFieldType(partitioningKey));
            ++index;
        }
        return keyTypes;
    }

    public static List<IAType> getBTreeIndexKeyTypes(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
        List<Integer> keySourceIndicators = indexDetails.getKeyFieldSourceIndicators();
        ArrayList<IAType> indexKeyTypes = new ArrayList<IAType>();
        for (int i = 0; i < indexDetails.getKeyFieldNames().size(); ++i) {
            Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(indexDetails.getKeyFieldTypes().get(i), indexDetails.getKeyFieldNames().get(i), KeyFieldTypeUtil.chooseSource(keySourceIndicators, i, recordType, metaRecordType));
            indexKeyTypes.add((IAType)keyPairType.first);
        }
        return indexKeyTypes;
    }

    public static List<IAType> getArrayBTreeIndexKeyTypes(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        Index.ArrayIndexDetails indexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
        ArrayList<IAType> indexKeyTypes = new ArrayList<IAType>();
        for (Index.ArrayIndexElement e : indexDetails.getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                ARecordType sourceType = e.getSourceIndicator() == 0 ? recordType : metaRecordType;
                Pair<IAType, Boolean> keyPairType = ArrayIndexUtil.getNonNullableOpenFieldType(e.getTypeList().get(i), ArrayIndexUtil.getFlattenedKeyFieldNames(e.getUnnestList(), e.getProjectList().get(i)), sourceType, ArrayIndexUtil.getArrayDepthIndicator(e.getUnnestList(), e.getProjectList().get(i)));
                indexKeyTypes.add((IAType)keyPairType.first);
            }
        }
        return indexKeyTypes;
    }

    public static List<IAType> getRTreeIndexKeyTypes(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
        List<Integer> keySourceIndicators = indexDetails.getKeyFieldSourceIndicators();
        ArrayList<IAType> indexKeyTypes = new ArrayList<IAType>();
        ARecordType targetRecType = KeyFieldTypeUtil.chooseSource(keySourceIndicators, 0, recordType, metaRecordType);
        Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(indexDetails.getKeyFieldTypes().get(0), indexDetails.getKeyFieldNames().get(0), targetRecType);
        IAType keyType = (IAType)keyPairType.first;
        IAType nestedKeyType = NonTaggedFormatUtil.getNestedSpatialType((ATypeTag)keyType.getTypeTag());
        int numKeys = KeyFieldTypeUtil.getNumSecondaryKeys(index, targetRecType, metaRecordType);
        for (int i = 0; i < numKeys; ++i) {
            indexKeyTypes.add(nestedKeyType);
        }
        return indexKeyTypes;
    }

    public static int getNumSecondaryKeys(Index index, ARecordType recordType, ARecordType metaRecordType) throws AlgebricksException {
        switch (index.getIndexType()) {
            case ARRAY: {
                return ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum);
            }
            case BTREE: {
                return ((Index.ValueIndexDetails)index.getIndexDetails()).getKeyFieldNames().size();
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                return ((Index.TextIndexDetails)index.getIndexDetails()).getKeyFieldNames().size();
            }
            case RTREE: {
                Index.ValueIndexDetails indexDetails = (Index.ValueIndexDetails)index.getIndexDetails();
                List<Integer> keySourceIndicators = indexDetails.getKeyFieldSourceIndicators();
                Pair<IAType, Boolean> keyPairType = Index.getNonNullableOpenFieldType(indexDetails.getKeyFieldTypes().get(0), indexDetails.getKeyFieldNames().get(0), KeyFieldTypeUtil.chooseSource(keySourceIndicators, 0, recordType, metaRecordType));
                IAType keyType = (IAType)keyPairType.first;
                return NonTaggedFormatUtil.getNumDimensions((ATypeTag)keyType.getTypeTag()) * 2;
            }
        }
        throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{index.getIndexType()});
    }

    public static ARecordType chooseSource(List<Integer> keySourceIndicators, int index, ARecordType recordType, ARecordType metaRecordType) {
        return keySourceIndicators.get(index) == 0 ? recordType : metaRecordType;
    }

    public static Triple<IAType, Boolean, Boolean> getKeyUnnestType(ARecordType inputType, List<List<String>> unnestPathList, SourceLocation sourceLoc) throws CompilationException {
        if (unnestPathList.isEmpty()) {
            return new Triple((Object)inputType, (Object)false, (Object)false);
        }
        ARecordType itemType = inputType;
        boolean itemTypeNullable = false;
        boolean itemTypeMissable = false;
        for (List<String> unnestPath : unnestPathList) {
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{ATypeTag.OBJECT, itemType.getTypeTag()});
            }
            ARecordType itemRecordType = itemType;
            Triple<IAType, Boolean, Boolean> fieldTypeResult = KeyFieldTypeUtil.getKeyProjectType(itemRecordType, unnestPath, sourceLoc);
            if (fieldTypeResult == null) {
                return null;
            }
            IAType fieldType = (IAType)fieldTypeResult.first;
            boolean fieldTypeNullable = (Boolean)fieldTypeResult.second;
            boolean fieldTypeMissable = (Boolean)fieldTypeResult.third;
            if (!fieldType.getTypeTag().isListType()) {
                throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{ExceptionUtil.toExpectedTypeString((byte[])new byte[]{ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG}), fieldType});
            }
            AbstractCollectionType fieldListType = (AbstractCollectionType)fieldType;
            IAType fieldListItemType = fieldListType.getItemType();
            boolean fieldListItemTypeNullable = false;
            boolean fieldListItemTypeMissable = false;
            if (fieldListItemType.getTypeTag() == ATypeTag.UNION) {
                AUnionType fieldListItemTypeUnion = (AUnionType)fieldListItemType;
                fieldListItemType = fieldListItemTypeUnion.getActualType();
                fieldListItemTypeNullable = fieldListItemTypeUnion.isNullableType();
                fieldListItemTypeMissable = fieldListItemTypeUnion.isMissableType();
            }
            itemType = fieldListItemType;
            itemTypeNullable = itemTypeNullable || fieldTypeNullable || fieldListItemTypeNullable;
            itemTypeMissable = itemTypeMissable || fieldTypeMissable || fieldListItemTypeMissable;
        }
        return new Triple((Object)itemType, (Object)itemTypeNullable, (Object)itemTypeMissable);
    }

    public static Triple<IAType, Boolean, Boolean> getKeyProjectType(ARecordType inputType, List<String> path, SourceLocation sourceLoc) throws CompilationException {
        ARecordType itemType = inputType;
        boolean itemTypeNullable = false;
        boolean itemTypeMissable = false;
        for (String step : path) {
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                throw new CompilationException(ErrorCode.TYPE_MISMATCH_GENERIC, sourceLoc, new Serializable[]{ATypeTag.OBJECT, itemType.getTypeTag()});
            }
            ARecordType itemRecordType = itemType;
            IAType fieldType = itemRecordType.getFieldType(step);
            if (fieldType == null) {
                if (itemRecordType.isOpen()) {
                    return null;
                }
                throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(path)});
            }
            if (fieldType.getTypeTag() == ATypeTag.UNION) {
                AUnionType fieldTypeUnion = (AUnionType)fieldType;
                itemType = fieldTypeUnion.getActualType();
                itemTypeNullable = itemTypeNullable || fieldTypeUnion.isNullableType();
                itemTypeMissable = itemTypeMissable || fieldTypeUnion.isMissableType();
                continue;
            }
            itemType = fieldType;
        }
        return new Triple((Object)itemType, (Object)itemTypeNullable, (Object)itemTypeMissable);
    }

    public static IAType makeUnknownableType(IAType primeType, boolean nullable, boolean missable) {
        IAType type = Objects.requireNonNull(primeType);
        if (nullable) {
            type = AUnionType.createNullableType((IAType)type);
        }
        if (missable) {
            type = AUnionType.createMissableType((IAType)type);
        }
        return type;
    }
}

