/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.SyncableOutputStreamOptions;
import java.time.Duration;

final class AutoValue_SyncableOutputStreamOptions
extends SyncableOutputStreamOptions {
    private final boolean appendEnabled;
    private final Duration minSyncInterval;
    private final boolean syncOnFlushEnabled;

    private AutoValue_SyncableOutputStreamOptions(boolean appendEnabled, Duration minSyncInterval, boolean syncOnFlushEnabled) {
        this.appendEnabled = appendEnabled;
        this.minSyncInterval = minSyncInterval;
        this.syncOnFlushEnabled = syncOnFlushEnabled;
    }

    @Override
    public boolean isAppendEnabled() {
        return this.appendEnabled;
    }

    @Override
    public Duration getMinSyncInterval() {
        return this.minSyncInterval;
    }

    @Override
    public boolean isSyncOnFlushEnabled() {
        return this.syncOnFlushEnabled;
    }

    public String toString() {
        return "SyncableOutputStreamOptions{appendEnabled=" + this.appendEnabled + ", minSyncInterval=" + this.minSyncInterval + ", syncOnFlushEnabled=" + this.syncOnFlushEnabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SyncableOutputStreamOptions) {
            SyncableOutputStreamOptions that = (SyncableOutputStreamOptions)o;
            return this.appendEnabled == that.isAppendEnabled() && this.minSyncInterval.equals(that.getMinSyncInterval()) && this.syncOnFlushEnabled == that.isSyncOnFlushEnabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.appendEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.minSyncInterval.hashCode();
        h$ *= 1000003;
        return h$ ^= this.syncOnFlushEnabled ? 1231 : 1237;
    }

    @Override
    public SyncableOutputStreamOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SyncableOutputStreamOptions.Builder {
        private Boolean appendEnabled;
        private Duration minSyncInterval;
        private Boolean syncOnFlushEnabled;

        Builder() {
        }

        private Builder(SyncableOutputStreamOptions source) {
            this.appendEnabled = source.isAppendEnabled();
            this.minSyncInterval = source.getMinSyncInterval();
            this.syncOnFlushEnabled = source.isSyncOnFlushEnabled();
        }

        @Override
        public SyncableOutputStreamOptions.Builder setAppendEnabled(boolean appendEnabled) {
            this.appendEnabled = appendEnabled;
            return this;
        }

        @Override
        public SyncableOutputStreamOptions.Builder setMinSyncInterval(Duration minSyncInterval) {
            if (minSyncInterval == null) {
                throw new NullPointerException("Null minSyncInterval");
            }
            this.minSyncInterval = minSyncInterval;
            return this;
        }

        @Override
        public SyncableOutputStreamOptions.Builder setSyncOnFlushEnabled(boolean syncOnFlushEnabled) {
            this.syncOnFlushEnabled = syncOnFlushEnabled;
            return this;
        }

        @Override
        public SyncableOutputStreamOptions build() {
            if (this.appendEnabled == null || this.minSyncInterval == null || this.syncOnFlushEnabled == null) {
                StringBuilder missing = new StringBuilder();
                if (this.appendEnabled == null) {
                    missing.append(" appendEnabled");
                }
                if (this.minSyncInterval == null) {
                    missing.append(" minSyncInterval");
                }
                if (this.syncOnFlushEnabled == null) {
                    missing.append(" syncOnFlushEnabled");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SyncableOutputStreamOptions(this.appendEnabled, this.minSyncInterval, this.syncOnFlushEnabled);
        }
    }
}

