/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractIntConstructorEvaluator;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractInt32ConstructorEvaluator
extends AbstractIntConstructorEvaluator {
    private final AMutableInt32 aInt32 = new AMutableInt32(0);
    private final ISerializerDeserializer<AInt32> int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private final ISerializerDeserializer<ADouble> doubleSerdeNonTagged = SerializerDeserializerProvider.INSTANCE.getNonTaggedSerializerDeserializer((IAType)BuiltinType.ADOUBLE);
    private final UTF8StringPointable utf8Ptr = new UTF8StringPointable();
    private final MutableBoolean maybeNumeric = new MutableBoolean();

    protected AbstractInt32ConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case INTEGER: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case TINYINT: 
            case SMALLINT: {
                this.promoteNumeric(inputType, bytes, startOffset + 1, len - 1, result);
                break;
            }
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: {
                this.demoteNumeric(inputType, bytes, startOffset + 1, len - 1, result);
                break;
            }
            case BOOLEAN: {
                boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                this.aInt32.setValue(b ? 1 : 0);
                this.resultStorage.reset();
                this.int32Serde.serialize((Object)this.aInt32, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (NumberUtils.parseInt32(this.utf8Ptr, this.aInt32, this.maybeNumeric)) {
                    this.resultStorage.reset();
                    this.int32Serde.serialize((Object)this.aInt32, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                if (this.maybeNumeric.booleanValue() && NumberUtils.parseDouble(this.utf8Ptr, this.aDouble)) {
                    this.tmpStorage.reset();
                    this.doubleSerdeNonTagged.serialize((Object)this.aDouble, this.tmpOut);
                    this.demoteNumeric(ATypeTag.DOUBLE, this.tmpStorage.getByteArray(), this.tmpStorage.getStartOffset(), this.tmpStorage.getLength(), result);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected final BuiltinType getTargetType() {
        return BuiltinType.AINT32;
    }
}

