/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.out.pointer;

import org.apache.asterix.column.bytes.stream.out.pointer.IReservedPointer;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class GrowableBytesPointer
implements IReservedPointer {
    private final ArrayBackedValueStorage storage;
    private int offset;

    public GrowableBytesPointer(ArrayBackedValueStorage storage) {
        this.storage = storage;
    }

    public void setPointer(int offset) {
        this.offset = offset;
    }

    @Override
    public void setByte(byte value) {
        this.storage.getByteArray()[this.offset] = value;
    }

    @Override
    public void setInteger(int value) {
        IntegerPointable.setInteger((byte[])this.storage.getByteArray(), (int)this.offset, (int)value);
    }

    @Override
    public void reset() {
        this.offset = -1;
    }

    @Override
    public boolean isSet() {
        return this.offset >= 0;
    }
}

