/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.cc;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.asterix.algebra.base.ILangExtension;
import org.apache.asterix.app.cc.IGlobalRecoveryExtension;
import org.apache.asterix.app.cc.IStatementExecutorExtension;
import org.apache.asterix.app.translator.DefaultStatementExecutorFactory;
import org.apache.asterix.common.api.ExtensionId;
import org.apache.asterix.common.api.IExtension;
import org.apache.asterix.common.api.INamespaceResolver;
import org.apache.asterix.common.cluster.IGlobalRecoveryManager;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.context.IStorageComponentProvider;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.SqlppCompilationProvider;
import org.apache.asterix.hyracks.bootstrap.GlobalRecoveryManager;
import org.apache.asterix.metadata.api.ICCExtensionManager;
import org.apache.asterix.metadata.api.IMetadataExtension;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.runtime.functions.FunctionCollection;
import org.apache.asterix.runtime.functions.FunctionManager;
import org.apache.asterix.translator.IStatementExecutorFactory;
import org.apache.asterix.utils.ExtensionUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CCExtensionManager
implements ICCExtensionManager {
    private final IStatementExecutorExtension statementExecutorExtension;
    private final ILangCompilationProvider sqlppCompilationProvider;
    private final IFunctionManager functionManager;
    private final IGlobalRecoveryExtension globalRecoveryExtension;
    private final Function<ICcApplicationContext, IMetadataProvider<?, ?>> metadataProviderFactory;
    private IStatementExecutorFactory statementExecutorFactory;

    public CCExtensionManager(List<AsterixExtension> list, INamespaceResolver namespaceResolver) throws InstantiationException, IllegalAccessException, ClassNotFoundException, HyracksDataException {
        Pair<ExtensionId, ILangCompilationProvider> sqlppcp = null;
        Pair<ExtensionId, IFunctionManager> fm = null;
        IStatementExecutorExtension see = null;
        IGlobalRecoveryExtension gre = null;
        IMetadataExtension mpfe = null;
        if (list != null) {
            HashSet<ExtensionId> extensionIds = new HashSet<ExtensionId>();
            for (AsterixExtension extensionConf : list) {
                IExtension extension = (IExtension)Class.forName(extensionConf.getClassName()).newInstance();
                extension.configure(extensionConf.getArgs());
                if (!extensionIds.add(extension.getId())) {
                    throw new RuntimeDataException(ErrorCode.EXTENSION_ID_CONFLICT, new Serializable[]{extension.getId()});
                }
                switch (extension.getExtensionKind()) {
                    case STATEMENT_EXECUTOR: {
                        see = ExtensionUtil.extendStatementExecutor(see, (IStatementExecutorExtension)extension);
                        break;
                    }
                    case LANG: {
                        ILangExtension le = (ILangExtension)extension;
                        sqlppcp = ExtensionUtil.extendLangCompilationProvider(ILangExtension.Language.SQLPP, sqlppcp, le, namespaceResolver);
                        fm = ExtensionUtil.extendFunctionManager(fm, le);
                        break;
                    }
                    case RECOVERY: {
                        gre = (IGlobalRecoveryExtension)extension;
                        break;
                    }
                    case METADATA: {
                        IMetadataExtension mde = (IMetadataExtension)extension;
                        mpfe = ExtensionUtil.extendMetadataProviderFactory(mpfe, mde);
                    }
                }
            }
        }
        this.statementExecutorExtension = see;
        this.sqlppCompilationProvider = sqlppcp == null ? new SqlppCompilationProvider(namespaceResolver) : (ILangCompilationProvider)sqlppcp.second;
        this.functionManager = fm == null ? new FunctionManager(FunctionCollection.createDefaultFunctionCollection()) : (IFunctionManager)fm.second;
        this.globalRecoveryExtension = gre;
        this.metadataProviderFactory = mpfe != null ? mpfe.getMetadataProviderFactory() : null;
    }

    @Deprecated
    public IStatementExecutorFactory getQueryTranslatorFactory() {
        return this.getStatementExecutorFactory(null);
    }

    public IStatementExecutorFactory getStatementExecutorFactory(ExecutorService executorService) {
        if (this.statementExecutorFactory == null) {
            this.statementExecutorFactory = this.statementExecutorExtension == null ? new DefaultStatementExecutorFactory(executorService) : this.statementExecutorExtension.getStatementExecutorFactory(executorService);
        }
        return this.statementExecutorFactory;
    }

    public ILangCompilationProvider getCompilationProvider(ILangExtension.Language lang) {
        switch (lang) {
            case SQLPP: {
                return this.sqlppCompilationProvider;
            }
        }
        throw new IllegalArgumentException(String.valueOf(lang));
    }

    public IGlobalRecoveryManager getGlobalRecoveryManager(ICCServiceContext serviceCtx, IHyracksClientConnection hcc, IStorageComponentProvider componentProvider) {
        if (this.globalRecoveryExtension == null) {
            return new GlobalRecoveryManager(serviceCtx, hcc, componentProvider);
        }
        return this.globalRecoveryExtension.getGlobalRecoveryManager(serviceCtx, hcc, componentProvider);
    }

    public IFunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public Function<ICcApplicationContext, IMetadataProvider<?, ?>> getMetadataProviderFactory() {
        return this.metadataProviderFactory;
    }
}

