/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.repository.util;

import java.io.File;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.i18n.Messages;

public class DeploymentFileData {
    private File file;
    private ClassLoader classLoader;
    private Deployer deployer;
    private URL url;
    private Object serviceMetaData;

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public DeploymentFileData(File file) {
        this.file = file;
    }

    public DeploymentFileData(File file, Deployer deployer) {
        this(file);
        this.deployer = deployer;
    }

    public DeploymentFileData(URL url, Deployer deployer, ClassLoader classLoader) {
        this.deployer = deployer;
        this.url = url;
        this.classLoader = classLoader;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        String path = this.url.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isModuleArchiveFile(String filename) {
        return filename.endsWith(".mar");
    }

    public static boolean isServiceArchiveFile(String filename) {
        return filename.endsWith(".jar") | filename.endsWith(".aar");
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        return fileName.substring(index + 1);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(boolean isDirectory, ClassLoader parent, File file, boolean isChildFirstClassLoading) throws AxisFault {
        if (!isDirectory) {
            if (this.file != null) {
                try {
                    if (!this.file.exists()) {
                        throw new AxisFault(Messages.getMessage("fileNotFound", this.file.getAbsolutePath()));
                    }
                    this.classLoader = Utils.createClassLoader(this.file.toURI().toURL(), null, parent, file, isChildFirstClassLoading);
                }
                catch (Exception e) {
                    throw AxisFault.makeFault(e);
                }
            }
        } else if (this.file != null) {
            this.classLoader = Utils.getClassLoader(parent, this.file, isChildFirstClassLoading);
        }
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public void deploy() throws DeploymentException {
        if (this.deployer != null) {
            this.deployer.deploy(this);
        }
    }

    public Object getServiceMetaData() {
        return this.serviceMetaData;
    }

    public void setServiceMetaData(Object serviceMetaData) {
        this.serviceMetaData = serviceMetaData;
    }
}

