/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.http.executor;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.URI;
import org.apache.brooklyn.util.http.auth.Credentials;
import org.apache.brooklyn.util.http.executor.HttpConfig;
import org.apache.brooklyn.util.http.executor.HttpRequest;

@Beta
public class HttpRequestImpl
implements HttpRequest {
    protected final URI uri;
    protected final String method;
    protected final byte[] body;
    protected final Multimap<String, String> headers;
    protected final Credentials credentials;
    protected final HttpConfig config;

    protected HttpRequestImpl(HttpRequest.Builder builder) {
        this.uri = (URI)Preconditions.checkNotNull((Object)builder.uri, (Object)"uri");
        this.method = (String)Preconditions.checkNotNull((Object)builder.method, (Object)"method");
        this.body = builder.body;
        this.headers = Multimaps.unmodifiableMultimap((Multimap)ArrayListMultimap.create((Multimap)((Multimap)Preconditions.checkNotNull(builder.headers, (Object)"headers"))));
        this.credentials = builder.credentials;
        this.config = builder.config;
    }

    public HttpRequestImpl(HttpRequestImpl httpRequest) {
        this.uri = (URI)Preconditions.checkNotNull((Object)httpRequest.uri, (Object)"uri");
        this.method = (String)Preconditions.checkNotNull((Object)httpRequest.method, (Object)"method");
        this.body = httpRequest.body;
        this.headers = Multimaps.unmodifiableMultimap((Multimap)ArrayListMultimap.create((Multimap)((Multimap)Preconditions.checkNotNull(httpRequest.headers, (Object)"headers"))));
        this.credentials = httpRequest.credentials;
        this.config = httpRequest.config;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public byte[] body() {
        return this.body;
    }

    @Override
    public Multimap<String, String> headers() {
        return this.headers;
    }

    @Override
    public Credentials credentials() {
        return this.credentials;
    }

    @Override
    public HttpConfig config() {
        return this.config;
    }
}

