/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.scriptbuilder.ScriptBuilder;
import org.jclouds.scriptbuilder.domain.AcceptsStatementVisitor;
import org.jclouds.scriptbuilder.domain.CreateRunScript;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.StatementVisitor;
import org.jclouds.scriptbuilder.domain.Statements;

public class InitScript
extends ForwardingObject
implements Statement,
AcceptsStatementVisitor {
    protected final String instanceName;
    protected final String instanceHome;
    protected final String logDir;
    protected final Map<String, String> exports;
    protected final StatementList init;
    protected final StatementList run;
    protected final ScriptBuilder delegate;

    public static Builder builder() {
        return new Builder();
    }

    protected InitScript(String instanceName, String instanceHome, String logDir, Map<String, String> exports, StatementList init, StatementList run) {
        this.instanceName = (String)Preconditions.checkNotNull((Object)instanceName, (Object)"INSTANCE_NAME");
        this.instanceHome = (String)Preconditions.checkNotNull((Object)instanceHome, (Object)"INSTANCE_HOME");
        this.logDir = (String)Preconditions.checkNotNull((Object)logDir, (Object)"LOG_DIR");
        this.exports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(exports, (Object)"exports")));
        this.init = (StatementList)Preconditions.checkNotNull((Object)init, (Object)"init");
        this.run = (StatementList)Preconditions.checkNotNull((Object)run, (Object)"run");
        Preconditions.checkArgument((!run.delegate().isEmpty() ? 1 : 0) != 0, (Object)"you must specify at least one statement to run");
        this.delegate = InitScript.makeInitScriptStatement(instanceName, instanceHome, logDir, exports, init, run);
    }

    public static ScriptBuilder makeInitScriptStatement(String instanceName, String instanceHome, String logDir, Map<String, String> exports, StatementList init, StatementList run) {
        ImmutableMap defaultExports = ImmutableMap.of((Object)"INSTANCE_NAME", (Object)instanceName, (Object)"INSTANCE_HOME", (Object)instanceHome, (Object)"LOG_DIR", (Object)logDir);
        String exitStatusFile = String.format("%s/rc", logDir);
        run = new StatementList((Iterable<Statement>)ImmutableList.builder().add((Object)Statements.interpret("rm -f " + exitStatusFile)).add((Object)Statements.interpret(String.format("trap 'echo $?>%s' 0 1 2 3 15", exitStatusFile))).addAll((Iterable)run.delegate()).build());
        CreateRunScript createRunScript = Statements.createRunScript(instanceName, Iterables.concat(exports.keySet(), defaultExports.keySet()), "{varl}INSTANCE_HOME{varr}", (Iterable<Statement>)((Object)run));
        return new ScriptBuilder().addEnvironmentVariableScope("default", (Map<String, String>)defaultExports).addEnvironmentVariableScope(instanceName, exports).addStatement(Statements.switchArg(1, (Map<String, Statement>)new ImmutableMap.Builder().put((Object)"init", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.call(instanceName, new String[0]), init, createRunScript)).put((Object)"status", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.findPid("{varl}INSTANCE_NAME{varr}"), Statements.interpret("echo {varl}FOUND_PID{varr}{lf}"))).put((Object)"stop", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.findPid("{varl}INSTANCE_NAME{varr}"), Statements.kill())).put((Object)"start", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), ScriptBuilder.forget("{varl}INSTANCE_NAME{varr}", "{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}", "{varl}LOG_DIR{varr}"))).put((Object)"stdout", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("cat {varl}LOG_DIR{varr}{fs}stdout.log{lf}"))).put((Object)"stderr", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("cat {varl}LOG_DIR{varr}{fs}stderr.log{lf}"))).put((Object)"exitstatus", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("[ -f $LOG_DIR/rc ] && cat $LOG_DIR/rc"))).put((Object)"tail", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stdout.log{lf}"))).put((Object)"tailerr", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("tail {varl}LOG_DIR{varr}{fs}stderr.log{lf}"))).put((Object)"run", (Object)Statements.newStatementList(ScriptBuilder.call("default", new String[0]), Statements.interpret("{varl}INSTANCE_HOME{varr}{fs}{varl}INSTANCE_NAME{varr}.{sh}{lf}"))).build()));
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstanceHome() {
        return this.instanceHome;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public StatementList getInitStatement() {
        return this.init;
    }

    public StatementList getRunStatement() {
        return this.init;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instanceName});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitScript)) {
            return false;
        }
        InitScript that = (InitScript)obj;
        return Objects.equal((Object)this.instanceName, (Object)that.instanceName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("INSTANCE_NAME", (Object)this.instanceName).toString();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        this.delegate().accept(visitor);
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return this.delegate().functionDependencies(family);
    }

    @Override
    public String render(OsFamily family) {
        return this.delegate().render(family);
    }

    protected ScriptBuilder delegate() {
        return this.delegate;
    }

    public static class Builder {
        protected String instanceName;
        protected String instanceHome = "{tmp}{fs}{varl}INSTANCE_NAME{varr}";
        protected String logDir = "{varl}INSTANCE_HOME{varr}";
        protected Map<String, String> exports = ImmutableMap.of();
        protected StatementList init = new StatementList(new Statement[0]);
        protected StatementList run = new StatementList(new Statement[0]);

        public Builder name(String instanceName) {
            this.instanceName = (String)Preconditions.checkNotNull((Object)instanceName, (Object)"INSTANCE_NAME");
            return this;
        }

        public Builder home(String instanceHome) {
            this.instanceHome = (String)Preconditions.checkNotNull((Object)instanceHome, (Object)"INSTANCE_HOME");
            return this;
        }

        public Builder logDir(String logDir) {
            this.logDir = (String)Preconditions.checkNotNull((Object)logDir, (Object)"LOG_DIR");
            return this;
        }

        public Builder exportVariables(Map<String, String> exports) {
            this.exports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(exports, (Object)"exports")));
            return this;
        }

        public Builder run(Statement run) {
            this.run = new StatementList((Statement)Preconditions.checkNotNull((Object)run, (Object)"run"));
            return this;
        }

        public Builder run(Statement ... run) {
            this.run = new StatementList((Statement[])Preconditions.checkNotNull((Object)run, (Object)"run"));
            return this;
        }

        public Builder run(Iterable<Statement> run) {
            this.run = new StatementList((Iterable)Preconditions.checkNotNull(run, (Object)"run"));
            return this;
        }

        public Builder run(StatementList run) {
            this.run = (StatementList)Preconditions.checkNotNull((Object)run, (Object)"run");
            return this;
        }

        public Builder init(Statement init) {
            this.init = new StatementList((Statement)Preconditions.checkNotNull((Object)init, (Object)"init"));
            return this;
        }

        public Builder init(Statement ... init) {
            this.init = new StatementList((Statement[])Preconditions.checkNotNull((Object)init, (Object)"init"));
            return this;
        }

        public Builder init(Iterable<Statement> init) {
            this.init = new StatementList((Iterable)Preconditions.checkNotNull(init, (Object)"init"));
            return this;
        }

        public Builder init(StatementList init) {
            this.init = (StatementList)Preconditions.checkNotNull((Object)init, (Object)"init");
            return this;
        }

        public InitScript build() {
            return new InitScript(this.instanceName, this.instanceHome, this.logDir, this.exports, this.init, this.run);
        }
    }
}

