/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.internal.LocationInternal;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.usage.ApplicationUsage;
import org.apache.brooklyn.core.mgmt.usage.LocationUsage;
import org.apache.brooklyn.core.mgmt.usage.UsageListener;
import org.apache.brooklyn.core.mgmt.usage.UsageManager;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalUsageManager
implements UsageManager {
    private static final Logger log = LoggerFactory.getLogger(LocalUsageManager.class);
    @VisibleForTesting
    public static final String APPLICATION_USAGE_KEY = "usage-application";
    @VisibleForTesting
    public static final String LOCATION_USAGE_KEY = "usage-location";
    private final LocalManagementContext managementContext;
    private final Object mutex = new Object();
    private final List<UsageListener> listeners = Lists.newCopyOnWriteArrayList();
    private final AtomicInteger listenerQueueSize = new AtomicInteger();
    private ListeningExecutorService listenerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("brooklyn-usagemanager-listener-%d").build()));

    public LocalUsageManager(LocalManagementContext managementContext) {
        this.managementContext = (LocalManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        TypeCoercions.BrooklynCommonAdaptorTypeCoercions.registerInstanceForClassnameAdapter(new ClassLoaderUtils(this.getClass(), (ManagementContext)managementContext), UsageListener.class);
        Collection listeners = managementContext.getBrooklynProperties().getConfig(UsageManager.USAGE_LISTENERS);
        if (listeners != null) {
            for (Object obj : listeners) {
                if (obj == null) {
                    throw new NullPointerException("null listener in config " + UsageManager.USAGE_LISTENERS);
                }
                if (!(obj instanceof UsageListener)) {
                    throw new ClassCastException("Configured object is not a UsageListener. This probably means coercion failed: " + obj);
                }
                UsageListener listener = (UsageListener)obj;
                if (listener instanceof ManagementContextInjectable) {
                    ((ManagementContextInjectable)((Object)listener)).setManagementContext(managementContext);
                }
                this.addUsageListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Duration timeout = this.managementContext.getBrooklynProperties().getConfig(UsageManager.USAGE_LISTENER_TERMINATION_TIMEOUT);
        if (this.listenerQueueSize.get() > 0) {
            log.info("Usage manager waiting for " + this.listenerQueueSize + " listener events for up to " + timeout);
        }
        ArrayList futures = Lists.newArrayList();
        for (final UsageListener listener : this.listeners) {
            ListenableFuture future = this.listenerExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    if (listener instanceof Closeable) {
                        try {
                            ((Closeable)((Object)listener)).close();
                        }
                        catch (IOException e) {
                            log.warn("Problem closing usage listener " + listener + " (continuing)", (Throwable)e);
                        }
                    }
                }
            });
            futures.add(future);
        }
        try {
            Futures.successfulAsList((Iterable)futures).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Problem terminiating usage listeners (continuing)", (Throwable)e);
        }
        finally {
            this.listenerExecutor.shutdownNow();
        }
    }

    private void execOnListeners(final Function<UsageListener, Void> job) {
        for (final UsageListener listener : this.listeners) {
            this.listenerQueueSize.incrementAndGet();
            this.listenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        job.apply((Object)listener);
                    }
                    catch (RuntimeException e) {
                        log.error("Problem notifying listener " + listener + " of " + job, (Throwable)e);
                        Exceptions.propagateIfFatal((Throwable)e);
                    }
                    finally {
                        LocalUsageManager.this.listenerQueueSize.decrementAndGet();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordApplicationEvent(final Application app, final Lifecycle state) {
        ApplicationUsage usage;
        log.debug("Storing application lifecycle usage event: application {} in state {}", new Object[]{app, state});
        ConcurrentMap<String, ApplicationUsage> eventMap = this.managementContext.getStorage().getMap(APPLICATION_USAGE_KEY);
        Object object = this.mutex;
        synchronized (object) {
            usage = (ApplicationUsage)eventMap.get(app.getId());
        }
        if (usage == null) {
            usage = new ApplicationUsage(app.getId(), app.getDisplayName(), app.getEntityType().getName(), ((EntityInternal)app).toMetadataRecord());
        }
        final ApplicationUsage.ApplicationEvent event = new ApplicationUsage.ApplicationEvent(state, this.getUser());
        Object object2 = this.mutex;
        synchronized (object2) {
            ApplicationUsage otherUsage = (ApplicationUsage)eventMap.get(app.getId());
            if (otherUsage != null) {
                usage = otherUsage;
            }
            usage.addEvent(event);
            eventMap.put(app.getId(), usage);
            this.execOnListeners(new Function<UsageListener, Void>(){

                public Void apply(UsageListener listener) {
                    listener.onApplicationEvent(new ApplicationMetadataImpl(Entities.proxy(app)), event);
                    return null;
                }

                public String toString() {
                    return "applicationEvent(" + app + ", " + (Object)((Object)state) + ")";
                }
            });
        }
    }

    @Override
    public void recordLocationEvent(Location loc, Lifecycle state) {
        Preconditions.checkNotNull((Object)loc, (Object)"location");
        if (((Boolean)loc.getConfig(AbstractLocation.TEMPORARY_LOCATION)).booleanValue()) {
            log.info("Ignoring location lifecycle usage event for {} (state {}), because location is a temporary location", (Object)loc, (Object)state);
            return;
        }
        Preconditions.checkNotNull((Object)((Object)state), (String)"state of location %s", (Object[])new Object[]{loc});
        if (loc.getId() == null) {
            log.error("Ignoring location lifecycle usage event for {} (state {}), because location has no id", (Object)loc, (Object)state);
            return;
        }
        if (this.managementContext.getStorage() == null) {
            log.warn("Cannot store location lifecycle usage event for {} (state {}), because storage not available", (Object)loc, (Object)state);
            return;
        }
        Object callerContext = loc.getConfig(LocationConfigKeys.CALLER_CONTEXT);
        if (callerContext != null && callerContext instanceof Entity) {
            Entity caller = (Entity)callerContext;
            this.recordLocationEvent(loc, caller, state);
        } else {
            log.trace("Not recording location lifecycle usage event for {} in state {}, because no caller context", new Object[]{loc, state});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordLocationEvent(final Location loc, Entity caller, final Lifecycle state) {
        LocationUsage usage;
        log.debug("Storing location lifecycle usage event: location {} in state {}; caller context {}", new Object[]{loc, state, caller});
        ConcurrentMap<String, LocationUsage> eventMap = this.managementContext.getStorage().getMap(LOCATION_USAGE_KEY);
        String entityTypeName = caller.getEntityType().getName();
        String appId = caller.getApplicationId();
        final LocationUsage.LocationEvent event = new LocationUsage.LocationEvent(state, caller.getId(), entityTypeName, appId, this.getUser());
        Object object = this.mutex;
        synchronized (object) {
            usage = (LocationUsage)eventMap.get(loc.getId());
        }
        if (usage == null) {
            usage = new LocationUsage(loc.getId(), ((LocationInternal)loc).toMetadataRecord());
        }
        object = this.mutex;
        synchronized (object) {
            LocationUsage otherUsage = (LocationUsage)eventMap.get(loc.getId());
            if (otherUsage != null) {
                usage = otherUsage;
            }
            usage.addEvent(event);
            eventMap.put(loc.getId(), usage);
            this.execOnListeners(new Function<UsageListener, Void>(){

                public Void apply(UsageListener listener) {
                    listener.onLocationEvent(new LocationMetadataImpl(loc), event);
                    return null;
                }

                public String toString() {
                    return "locationEvent(" + loc + ", " + (Object)((Object)state) + ")";
                }
            });
        }
    }

    @Override
    public LocationUsage getLocationUsage(String locationId) {
        BrooklynStorage storage = this.managementContext.getStorage();
        ConcurrentMap usageMap = storage.getMap(LOCATION_USAGE_KEY);
        return (LocationUsage)usageMap.get(locationId);
    }

    @Override
    public Set<LocationUsage> getLocationUsage(Predicate<? super LocationUsage> filter) {
        ConcurrentMap usageMap = this.managementContext.getStorage().getMap(LOCATION_USAGE_KEY);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (LocationUsage usage : usageMap.values()) {
            if (!filter.apply((Object)usage)) continue;
            result.add(usage);
        }
        return result;
    }

    @Override
    public ApplicationUsage getApplicationUsage(String appId) {
        BrooklynStorage storage = this.managementContext.getStorage();
        ConcurrentMap usageMap = storage.getMap(APPLICATION_USAGE_KEY);
        return (ApplicationUsage)usageMap.get(appId);
    }

    @Override
    public Set<ApplicationUsage> getApplicationUsage(Predicate<? super ApplicationUsage> filter) {
        ConcurrentMap usageMap = this.managementContext.getStorage().getMap(APPLICATION_USAGE_KEY);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ApplicationUsage usage : usageMap.values()) {
            if (!filter.apply((Object)usage)) continue;
            result.add(usage);
        }
        return result;
    }

    @Override
    public void addUsageListener(UsageListener listener) {
        this.listeners.add((UsageListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void removeUsageListener(UsageListener listener) {
        this.listeners.remove(listener);
    }

    private String getUser() {
        EntitlementContext entitlementContext = Entitlements.getEntitlementContext();
        if (entitlementContext != null) {
            return entitlementContext.user();
        }
        return null;
    }

    private static class LocationMetadataImpl
    implements UsageListener.LocationMetadata {
        private final Location loc;
        private String locationId;
        private Map<String, String> metadata;

        LocationMetadataImpl(Location loc) {
            this.loc = (Location)Preconditions.checkNotNull((Object)loc, (Object)"loc");
            this.locationId = loc.getId();
            this.metadata = ((LocationInternal)loc).toMetadataRecord();
        }

        @Override
        public Location getLocation() {
            return this.loc;
        }

        @Override
        public String getLocationId() {
            return this.locationId;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }

    private static class ApplicationMetadataImpl
    implements UsageListener.ApplicationMetadata {
        private final Application app;
        private String applicationId;
        private String applicationName;
        private String entityType;
        private String catalogItemId;
        private Map<String, String> metadata;

        ApplicationMetadataImpl(Application app) {
            this.app = (Application)Preconditions.checkNotNull((Object)app, (Object)"app");
            this.applicationId = app.getId();
            this.applicationName = app.getDisplayName();
            this.entityType = app.getEntityType().getName();
            this.catalogItemId = app.getCatalogItemId();
            this.metadata = ((EntityInternal)app).toMetadataRecord();
        }

        @Override
        public Application getApplication() {
            return this.app;
        }

        @Override
        public String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public String getEntityType() {
            return this.entityType;
        }

        @Override
        public String getCatalogItemId() {
            return this.catalogItemId;
        }

        @Override
        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

