/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrooklynYamlTypeInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BrooklynYamlTypeInstantiator.class);
    protected final Factory factory;

    protected BrooklynYamlTypeInstantiator(Factory factory) {
        this.factory = factory;
    }

    public abstract Maybe<String> getTypeName();

    public BrooklynClassLoadingContext getClassLoadingContext() {
        Preconditions.checkNotNull((Object)this.factory, (Object)"No factory set; cannot use this instance for type loading");
        return this.factory.loader;
    }

    public Class<?> getType() {
        return this.getType(Object.class);
    }

    public <T> Class<? extends T> getType(@Nonnull Class<T> type) {
        try {
            return this.getClassLoadingContext().loadClass((String)this.getTypeName().get(), type);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.debug("Unable to resolve " + type + " " + (String)this.getTypeName().get() + " (rethrowing) in spec " + this.factory.contextForLogging);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static class InstantiatorFromName
    extends BrooklynYamlTypeInstantiator {
        protected final String typeName;

        protected InstantiatorFromName(Factory factory, String typeName) {
            super(factory);
            this.typeName = typeName;
        }

        @Override
        public Maybe<String> getTypeName() {
            return Maybe.fromNullable((Object)this.typeName);
        }
    }

    public static class InstantiatorFromKey
    extends BrooklynYamlTypeInstantiator {
        protected final ConfigBag data;
        protected String typeKeyPrefix = null;

        protected InstantiatorFromKey(@Nullable Factory factory, ConfigBag data) {
            super(factory);
            this.data = data;
        }

        public static Maybe<String> extractTypeName(String prefix, ConfigBag data) {
            if (data == null) {
                return Maybe.absent();
            }
            return new InstantiatorFromKey(null, data).prefix(prefix).getTypeName();
        }

        public InstantiatorFromKey prefix(String prefix) {
            this.typeKeyPrefix = prefix;
            return this;
        }

        @Override
        public Maybe<String> getTypeName() {
            Maybe result = this.data.getStringKeyMaybe(this.getTypedKeyName());
            if (result.isAbsent() && this.typeKeyPrefix != null && (result = this.data.getStringKeyMaybe(this.typeKeyPrefix + "Type")).isAbsent()) {
                result = this.data.getStringKeyMaybe("type");
            }
            if (result.isAbsent() || result.get() == null) {
                return Maybe.absent((String)("Missing key 'type'" + (this.typeKeyPrefix != null ? " (or '" + this.getTypedKeyName() + "')" : "")));
            }
            if (result.get() instanceof String) {
                return Maybe.of((Object)((String)result.get()));
            }
            throw new IllegalArgumentException("Invalid value " + result.get().getClass() + " for " + this.getTypedKeyName() + "; expected String, got " + result.get());
        }

        protected String getTypedKeyName() {
            if (this.typeKeyPrefix != null) {
                return this.typeKeyPrefix + "_type";
            }
            return "type";
        }

        public Object newInstance() {
            return this.newInstance(null);
        }

        public <T> T newInstance(@Nullable Class<T> supertype) {
            Map<String, ?> cfg;
            Class<T> type = this.getType(supertype);
            Maybe result = Reflections.invokeConstructorFromArgs(type, (Object[])new Object[]{cfg = this.getConfigMap()});
            if (result.isPresent()) {
                return (T)result.get();
            }
            ConfigBag cfgBag = ConfigBag.newInstance(cfg);
            result = Reflections.invokeConstructorFromArgs(type, (Object[])new Object[]{cfgBag});
            if (result.isPresent()) {
                return (T)result.get();
            }
            if (cfg.isEmpty()) {
                result = Reflections.invokeConstructorFromArgs(type, (Object[])new Object[0]);
                if (result.isPresent()) {
                    return (T)result.get();
                }
            } else if (Configurable.class.isAssignableFrom(type) && (result = Reflections.invokeConstructorFromArgs(type, (Object[])new Object[0])).isPresent()) {
                BrooklynObjectInternal.ConfigurationSupportInternal configSupport = (BrooklynObjectInternal.ConfigurationSupportInternal)((Configurable)result.get()).config();
                configSupport.putAll(cfg);
                return (T)result.get();
            }
            throw new IllegalStateException("No known mechanism for constructing type " + type + " in " + this.factory.contextForLogging);
        }

        @Nonnull
        public Map<String, ?> getConfigMap() {
            MutableMap result = MutableMap.of();
            Object bc = this.data.getStringKey("brooklyn.config");
            if (bc != null) {
                if (bc instanceof Map) {
                    result.putAll((Map)bc);
                } else {
                    throw new IllegalArgumentException("brooklyn.config key in " + this.factory.contextForLogging + " should be a map, not " + bc.getClass() + " (" + bc + ")");
                }
            }
            return result;
        }
    }

    @Beta
    public static class Factory {
        final BrooklynClassLoadingContext loader;
        final Object contextForLogging;

        public Factory(BrooklynClassLoadingContext loader, Object contextForLogging) {
            this.loader = loader;
            this.contextForLogging = contextForLogging;
        }

        public InstantiatorFromKey from(Map<?, ?> data) {
            return new InstantiatorFromKey(this, ConfigBag.newInstance(data));
        }

        public InstantiatorFromKey from(ConfigBag data) {
            return new InstantiatorFromKey(this, data);
        }

        public InstantiatorFromName type(String typeName) {
            return new InstantiatorFromName(this, typeName);
        }
    }
}

