/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.templates.customize;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.brooklyn.location.jclouds.templates.customize.TemplateOptionCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.os.Os;
import org.jclouds.compute.options.TemplateOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoginUserPrivateKeyFileOption
implements TemplateOptionCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(LoginUserPrivateKeyFileOption.class);

    LoginUserPrivateKeyFileOption() {
    }

    @Override
    public void apply(TemplateOptions t, ConfigBag props, Object v) {
        if (v != null) {
            String privateKey;
            String privateKeyFileName = v.toString();
            try {
                privateKey = Files.toString((File)new File(Os.tidyPath((String)privateKeyFileName)), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                LOG.error(privateKeyFileName + "not found", (Throwable)e);
                throw Exceptions.propagate((Throwable)e);
            }
            t.overrideLoginPrivateKey(privateKey);
        }
    }
}

