/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.osgi;

import java.util.Map;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.Injector;

public class OsgiClassLoaderManager
implements ClassLoaderManager {
    private static final String CAYENNE_PACKAGE = "org/apache/cayenne";
    private static final String CAYENNE_DI_PACKAGE_SUFFIX = "/di";
    private ClassLoader applicationClassLoader;
    private ClassLoader cayenneServerClassLoader;
    private ClassLoader cayenneDiClassLoader;
    private Map<String, ClassLoader> perResourceClassLoaders;

    public OsgiClassLoaderManager(ClassLoader applicationClassLoader, Map<String, ClassLoader> perResourceClassLoaders) {
        this.applicationClassLoader = applicationClassLoader;
        this.cayenneDiClassLoader = Injector.class.getClassLoader();
        this.cayenneServerClassLoader = OsgiClassLoaderManager.class.getClassLoader();
        this.perResourceClassLoaders = perResourceClassLoaders;
    }

    @Override
    public ClassLoader getClassLoader(String resourceName) {
        String normalizedName;
        if (resourceName == null || resourceName.length() < 2) {
            return this.resourceClassLoader(resourceName);
        }
        String string = normalizedName = resourceName.charAt(0) == '/' ? resourceName.substring(1) : resourceName;
        if (normalizedName.startsWith(CAYENNE_PACKAGE)) {
            return normalizedName.substring(CAYENNE_PACKAGE.length()).startsWith(CAYENNE_DI_PACKAGE_SUFFIX) ? this.cayenneDiClassLoader() : this.cayenneServerClassLoader();
        }
        return this.resourceClassLoader(resourceName);
    }

    protected ClassLoader resourceClassLoader(String resourceName) {
        ClassLoader cl = this.perResourceClassLoaders.get(resourceName);
        return cl != null ? cl : this.applicationClassLoader;
    }

    protected ClassLoader cayenneDiClassLoader() {
        return this.cayenneDiClassLoader;
    }

    protected ClassLoader cayenneServerClassLoader() {
        return this.cayenneServerClassLoader;
    }
}

