/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.handlers;

import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UpgradeHandler_V7
implements UpgradeHandler {
    @Override
    public String getVersion() {
        return "7";
    }

    @Override
    public void processProjectDom(UpgradeUnit upgradeUnit) {
        Node node;
        Element domain = upgradeUnit.getDocument().getDocumentElement();
        domain.setAttribute("project-version", this.getVersion());
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            node = (Node)xpath.evaluate("/domain/property[@name='cayenne.DataDomain.usingExternalTransactions']", upgradeUnit.getDocument(), XPathConstants.NODE);
        }
        catch (Exception ex) {
            return;
        }
        if (node != null) {
            domain.removeChild(node);
        }
    }

    @Override
    public void processDataMapDom(UpgradeUnit upgradeUnit) {
        Element dataMap = upgradeUnit.getDocument().getDocumentElement();
        dataMap.setAttribute("xmlns", "http://cayenne.apache.org/schema/7/modelMap");
        dataMap.setAttribute("xsi:schemaLocation", "http://cayenne.apache.org/schema/7/modelMap https://cayenne.apache.org/schema/7/modelMap.xsd");
        dataMap.setAttribute("project-version", this.getVersion());
    }

    @Override
    public void processModel(DataChannelDescriptor dataChannelDescriptor) {
        for (DataMap dataMap : dataChannelDescriptor.getDataMaps()) {
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                ObjEntity superEntity = objEntity.getSuperEntity();
                if (superEntity == null) continue;
                this.removeShadowAttributes(objEntity, superEntity);
            }
        }
    }

    private void removeShadowAttributes(ObjEntity objEntity, ObjEntity superEntity) {
        ArrayList<String> delList = new ArrayList<String>();
        for (ObjAttribute subAttr : objEntity.getDeclaredAttributes()) {
            for (ObjAttribute superAttr : superEntity.getAttributes()) {
                if (!subAttr.getName().equals(superAttr.getName())) continue;
                delList.add(subAttr.getName());
            }
        }
        if (!delList.isEmpty()) {
            for (String i : delList) {
                objEntity.removeAttribute(i);
            }
        }
    }
}

