/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.query.SQLTemplate;

public class JUndoableCheckBoxEdit
extends AbstractUndoableEdit {
    private JCheckBox checkBox;
    private ActionListener actionListener;
    private JTabbedPane tabbedPane;
    private TreePath treePath;
    private Object targetObject;
    private EditorView editorView;
    private int selectedTabIndex;
    private boolean isSelected;

    JUndoableCheckBoxEdit(JCheckBox checkBox, ActionListener actionListener) {
        this.checkBox = checkBox;
        this.actionListener = actionListener;
        this.isSelected = checkBox.isSelected();
        this.editorView = ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
        this.treePath = this.editorView.getProjectTreeView().getSelectionPath();
        if (this.treePath != null) {
            DefaultMutableTreeNode newPath = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
            this.targetObject = newPath.getUserObject();
        }
        if (this.targetObject instanceof DataChannelDescriptor) {
            this.tabbedPane = this.editorView.getDataDomainView();
        }
        if (this.targetObject instanceof DataMap) {
            this.tabbedPane = this.editorView.getDataMapView();
        }
        if (this.targetObject instanceof ObjEntity) {
            this.tabbedPane = this.editorView.getObjDetailView();
        }
        if (this.targetObject instanceof SQLTemplate) {
            this.tabbedPane = this.editorView.getSqlTemplateView();
        }
        if (this.tabbedPane != null) {
            this.selectedTabIndex = this.tabbedPane.getSelectedIndex();
        }
    }

    private void restoreSelections() {
        this.editorView.getProjectTreeView().getSelectionModel().setSelectionPath(this.treePath);
        if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedIndex(this.selectedTabIndex);
        }
    }

    @Override
    public String getPresentationName() {
        return "CheckBox Change";
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.restoreSelections();
        this.checkBox.removeActionListener(this.actionListener);
        try {
            this.checkBox.setSelected(this.isSelected);
        }
        finally {
            this.checkBox.addActionListener(this.actionListener);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.restoreSelections();
        this.checkBox.removeActionListener(this.actionListener);
        try {
            this.checkBox.setSelected(!this.isSelected);
        }
        finally {
            this.checkBox.addActionListener(this.actionListener);
        }
    }
}

