/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.path.EmptyCayennePath;
import org.apache.cayenne.exp.path.MultiSegmentCayennePath;
import org.apache.cayenne.exp.path.PathParser;
import org.apache.cayenne.exp.path.SegmentList;
import org.apache.cayenne.exp.path.SingleSegmentCayennePath;

public interface CayennePath
extends Iterable<CayennePathSegment>,
Serializable {
    public static final int NO_MARKER = 0;
    public static final int PREFETCH_MARKER = 1;
    public static final CayennePath EMPTY_PATH = new EmptyCayennePath(0);

    public static CayennePath of(String path) {
        return CayennePath.of(path, 0);
    }

    public static CayennePath of(String path, int marker) {
        int counter;
        if (path == null || path.isEmpty()) {
            if (marker == 0) {
                return EMPTY_PATH;
            }
            return new EmptyCayennePath(marker);
        }
        CayennePathSegment[] segments = PathParser.parseAllSegments(path);
        if (segments == null) {
            return new SingleSegmentCayennePath(PathParser.parseSegment(path), marker);
        }
        for (counter = 0; counter < segments.length && segments[counter] != null; ++counter) {
        }
        return new MultiSegmentCayennePath(new SegmentList(segments, 0, counter), marker);
    }

    public static CayennePath of(CayennePath path, int marker) {
        if (path.marker() == marker) {
            return path;
        }
        return CayennePath.of(path.segments(), marker);
    }

    public static CayennePath of(List<CayennePathSegment> segments) {
        return CayennePath.of(segments, 0);
    }

    public static CayennePath of(List<CayennePathSegment> segments, int marker) {
        switch (segments.size()) {
            case 0: {
                return marker == 0 ? EMPTY_PATH : new EmptyCayennePath(marker);
            }
            case 1: {
                return new SingleSegmentCayennePath(segments.get(0), marker);
            }
        }
        if (segments instanceof SegmentList) {
            return new MultiSegmentCayennePath(segments, marker);
        }
        return new MultiSegmentCayennePath(List.copyOf(segments), marker);
    }

    public static CayennePathSegment segmentOf(String segment, boolean outer) {
        return new CayennePathSegment(segment, outer);
    }

    public static CayennePathSegment segmentOf(String segment) {
        return CayennePath.segmentOf(segment, false);
    }

    public List<CayennePathSegment> segments();

    default public int marker() {
        return 0;
    }

    default public CayennePath withMarker(int marker) {
        return CayennePath.of(this, marker);
    }

    default public boolean hasMarker(int marker) {
        return (this.marker() & marker) > 0;
    }

    default public int length() {
        return this.segments().size();
    }

    default public boolean isEmpty() {
        return this.segments().isEmpty();
    }

    public String toString();

    default public String value() {
        return this.toString();
    }

    default public CayennePathSegment first() {
        if (this.isEmpty()) {
            return null;
        }
        return this.segments().get(0);
    }

    default public CayennePathSegment last() {
        int length = this.length();
        if (length == 0) {
            return null;
        }
        return this.segments().get(length - 1);
    }

    default public CayennePath tail(int start) {
        if (start == 0) {
            return this;
        }
        return CayennePath.of(this.segments().subList(start, this.length()), this.marker());
    }

    default public CayennePath head(int end) {
        if (end == this.length()) {
            return this;
        }
        return CayennePath.of(this.segments().subList(0, end), this.marker());
    }

    default public CayennePath parent() {
        if (this.isEmpty()) {
            return EMPTY_PATH.withMarker(this.marker());
        }
        return this.head(this.length() - 1);
    }

    default public CayennePath dot(String next) {
        return this.dot(PathParser.parseSegment(next));
    }

    default public CayennePath dot(CayennePathSegment next) {
        ArrayList<CayennePathSegment> segments = new ArrayList<CayennePathSegment>(this.length() + 1);
        segments.addAll(this.segments());
        segments.add(next);
        return new MultiSegmentCayennePath(segments, this.marker());
    }

    default public CayennePath dot(CayennePath next) {
        ArrayList<CayennePathSegment> segments = new ArrayList<CayennePathSegment>(this.length() + next.length());
        segments.addAll(this.segments());
        segments.addAll(next.segments());
        return new MultiSegmentCayennePath(segments, this.marker());
    }
}

