/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.util.CompareToBuilder;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.Util;

public class ExportedKey
implements Comparable<ExportedKey> {
    private final KeyData pk;
    private final KeyData fk;
    private final short keySeq;

    ExportedKey(ResultSet rs) throws SQLException {
        String pkCatalog = rs.getString("PKTABLE_CAT");
        String pkSchema = rs.getString("PKTABLE_SCHEM");
        String pkTable = rs.getString("PKTABLE_NAME");
        String pkColumn = rs.getString("PKCOLUMN_NAME");
        String pkName = rs.getString("PK_NAME");
        this.pk = new KeyData(pkCatalog, pkSchema, pkTable, pkColumn, pkName);
        String fkCatalog = rs.getString("FKTABLE_CAT");
        String fkSchema = rs.getString("FKTABLE_SCHEM");
        String fkTable = rs.getString("FKTABLE_NAME");
        String fkColumn = rs.getString("FKCOLUMN_NAME");
        String fkName = rs.getString("FK_NAME");
        this.fk = new KeyData(fkCatalog, fkSchema, fkTable, fkColumn, fkName);
        this.keySeq = rs.getShort("KEY_SEQ");
    }

    public KeyData getPk() {
        return this.pk;
    }

    public KeyData getFk() {
        return this.fk;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ExportedKey rhs = (ExportedKey)obj;
        return new EqualsBuilder().append(this.pk, rhs.pk).append(this.fk, rhs.fk).append(this.keySeq, rhs.keySeq).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.pk).append(this.fk).append(this.keySeq).toHashCode();
    }

    @Override
    public int compareTo(ExportedKey rhs) {
        Objects.requireNonNull(rhs);
        if (rhs == this) {
            return 0;
        }
        return new CompareToBuilder().append(this.pk, rhs.pk).append(this.fk, rhs.fk).append(this.keySeq, rhs.keySeq).toComparison();
    }

    public String toString() {
        return this.getStrKey() + " # " + this.keySeq;
    }

    String getStrKey() {
        return this.pk + " <- " + this.fk;
    }

    public static class KeyData
    implements Comparable<KeyData> {
        private final String catalog;
        private final String schema;
        private final String table;
        private final String column;
        private final String name;

        KeyData(String catalog, String schema, String table, String column, String name) {
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.column = column;
            this.name = name;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getSchema() {
            return this.schema;
        }

        public String getTable() {
            return this.table;
        }

        public String getColumn() {
            return this.column;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.catalog + "." + this.schema + "." + this.table + "." + this.column;
        }

        @Override
        public int compareTo(KeyData rhs) {
            Objects.requireNonNull(rhs);
            if (rhs == this) {
                return 0;
            }
            return new CompareToBuilder().append(this.catalog, rhs.catalog).append(this.schema, rhs.schema).append(this.table, rhs.table).append(this.column, rhs.column).append(this.name, rhs.name).toComparison();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            KeyData rhs = (KeyData)obj;
            return new EqualsBuilder().append(this.catalog, rhs.catalog).append(this.schema, rhs.schema).append(this.table, rhs.table).append(this.column, rhs.column).append(this.name, rhs.name).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.catalog).append(this.schema).append(this.table).append(this.column).append(this.name).toHashCode();
        }

        public boolean validateEntity(DbEntity entity) {
            if (entity == null) {
                return false;
            }
            if (Util.isEmptyString(this.catalog) ? !Util.isEmptyString(entity.getCatalog()) : !this.catalog.equals(entity.getCatalog())) {
                return false;
            }
            if (Util.isEmptyString(this.schema)) {
                return Util.isEmptyString(entity.getSchema());
            }
            return this.schema.equals(entity.getSchema());
        }
    }
}

