/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog;

import org.apache.cayenne.commitlog.CommitLogFilter;
import org.apache.cayenne.commitlog.CommitLogListener;
import org.apache.cayenne.commitlog.meta.AnnotationCommitLogEntityFactory;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.configuration.runtime.CoreModule;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;

public class CommitLogModuleExtender {
    private final Binder binder;
    private ListBuilder<CommitLogListener> commitLogListeners;

    protected CommitLogModuleExtender(Binder binder) {
        this.binder = binder;
    }

    protected CommitLogModuleExtender initAllExtensions() {
        this.contributeCommitLogListeners();
        return this;
    }

    public CommitLogModuleExtender addListener(Class<? extends CommitLogListener> type) {
        this.contributeCommitLogListeners().add(type);
        return this;
    }

    public CommitLogModuleExtender addListener(CommitLogListener instance) {
        this.contributeCommitLogListeners().add((Object)instance);
        return this;
    }

    public CommitLogModuleExtender excludeFromTransaction() {
        return this.registerFilter(false);
    }

    public CommitLogModuleExtender includeInTransaction() {
        return this.registerFilter(true);
    }

    protected CommitLogModuleExtender registerFilter(boolean inTx) {
        CoreModule.extend((Binder)this.binder).addSyncFilter(CommitLogFilter.class, inTx);
        return this;
    }

    public CommitLogModuleExtender commitLogAnnotationEntitiesOnly() {
        return this.entityFactory(AnnotationCommitLogEntityFactory.class);
    }

    public CommitLogModuleExtender entityFactory(Class<? extends CommitLogEntityFactory> entityFactoryType) {
        this.binder.bind(CommitLogEntityFactory.class).to(entityFactoryType);
        return this;
    }

    private ListBuilder<CommitLogListener> contributeCommitLogListeners() {
        if (this.commitLogListeners == null) {
            this.commitLogListeners = this.binder.bindList(CommitLogListener.class);
        }
        return this.commitLogListeners;
    }
}

