/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public final class DetectCompressorTest {
    private static final CompressorStreamFactory factoryTrue = new CompressorStreamFactory(true);
    private static final CompressorStreamFactory factoryFalse = new CompressorStreamFactory(false);
    private static final CompressorStreamFactory factorySetTrue = new CompressorStreamFactory();
    private static final CompressorStreamFactory factorySetFalse;
    final CompressorStreamFactory factory = new CompressorStreamFactory();
    private final TestData[] tests = new TestData[]{new TestData("multiple.bz2", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.bz2", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.bz2", new char[]{'a'}, factoryFalse, false), new TestData("multiple.bz2", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.bz2", new char[]{'a'}, this.factory, false), new TestData("multiple.gz", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.gz", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.gz", new char[]{'a'}, factoryFalse, false), new TestData("multiple.gz", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.gz", new char[]{'a'}, this.factory, false), new TestData("multiple.xz", new char[]{'a', 'b'}, factoryTrue, true), new TestData("multiple.xz", new char[]{'a', 'b'}, factorySetTrue, true), new TestData("multiple.xz", new char[]{'a'}, factoryFalse, false), new TestData("multiple.xz", new char[]{'a'}, factorySetFalse, false), new TestData("multiple.xz", new char[]{'a'}, this.factory, false)};

    public static Stream<Arguments> getDetectLimitedByNameParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{"bla.txt.bz2", "bzip2"}), Arguments.of((Object[])new Object[]{"bla.tgz", "gz"}), Arguments.of((Object[])new Object[]{"bla.pack", "pack200"}), Arguments.of((Object[])new Object[]{"bla.tar.xz", "xz"}), Arguments.of((Object[])new Object[]{"bla.tar.deflatez", "deflate"}), Arguments.of((Object[])new Object[]{"bla.tar.lz4", "lz4-framed"}), Arguments.of((Object[])new Object[]{"bla.tar.lzma", "lzma"}), Arguments.of((Object[])new Object[]{"bla.tar.sz", "snappy-framed"}), Arguments.of((Object[])new Object[]{"bla.tar.Z", "z"}), Arguments.of((Object[])new Object[]{"bla.tar.zst", "zstd"}));
    }

    private CompressorInputStream createCompressorInputStream(String resource) throws CompressorException, IOException {
        return this.factory.createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTest.getFile(resource).toPath(), new OpenOption[0])));
    }

    private CompressorInputStream createCompressorInputStream(String resource, CompressorStreamFactory factory) throws CompressorException, IOException {
        return factory.createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTest.getFile(resource).toPath(), new OpenOption[0])));
    }

    private CompressorInputStream createCompressorInputStream(String resource, Set<String> compressorNames) throws CompressorException, IOException {
        return this.factory.createCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(AbstractTest.getFile(resource).toPath(), new OpenOption[0])), compressorNames);
    }

    private InputStream createInputStream(String fileName, int memoryLimitInKb) throws Exception {
        CompressorStreamFactory fac = new CompressorStreamFactory(true, memoryLimitInKb);
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(AbstractTest.getFile(fileName).toPath(), new OpenOption[0]));
        try {
            return fac.createCompressorInputStream((InputStream)is);
        }
        catch (CompressorException e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private String detect(String testFileName) throws IOException, CompressorException {
        return this.detect(testFileName, null);
    }

    private String detect(String testFileName, Set<String> compressorNames) throws IOException, CompressorException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(AbstractTest.getFile(testFileName).toPath(), new OpenOption[0]));){
            String string = compressorNames != null ? CompressorStreamFactory.detect((InputStream)is, compressorNames) : CompressorStreamFactory.detect((InputStream)is);
            return string;
        }
    }

    @Test
    void testCreateLimitedByName() throws Exception {
        try (CompressorInputStream bzip2 = this.createCompressorInputStream("bla.txt.bz2", Collections.singleton("bzip2"));){
            Assertions.assertNotNull((Object)bzip2);
            Assertions.assertInstanceOf(BZip2CompressorInputStream.class, (Object)bzip2);
        }
        try (CompressorInputStream gzip = this.createCompressorInputStream("bla.tgz", Collections.singleton("gz"));){
            Assertions.assertNotNull((Object)gzip);
            Assertions.assertInstanceOf(GzipCompressorInputStream.class, (Object)gzip);
        }
        try (CompressorInputStream pack200 = this.createCompressorInputStream("bla.pack", Collections.singleton("pack200"));){
            Assertions.assertNotNull((Object)pack200);
            Assertions.assertInstanceOf(Pack200CompressorInputStream.class, (Object)pack200);
        }
        try (CompressorInputStream xz = this.createCompressorInputStream("bla.tar.xz", Collections.singleton("xz"));){
            Assertions.assertNotNull((Object)xz);
            Assertions.assertInstanceOf(XZCompressorInputStream.class, (Object)xz);
        }
        try (CompressorInputStream zlib = this.createCompressorInputStream("bla.tar.deflatez", Collections.singleton("deflate"));){
            Assertions.assertNotNull((Object)zlib);
            Assertions.assertInstanceOf(DeflateCompressorInputStream.class, (Object)zlib);
        }
        try (CompressorInputStream zstd = this.createCompressorInputStream("bla.tar.zst", Collections.singleton("zstd"));){
            Assertions.assertNotNull((Object)zstd);
            Assertions.assertInstanceOf(ZstdCompressorInputStream.class, (Object)zstd);
        }
    }

    @Test
    void testCreateLimitedByNameNotFound() throws Exception {
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.txt.bz2", Collections.singleton("br")));
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.tgz", Collections.singleton("z")));
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.pack", Collections.singleton("snappy-framed")));
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.tar.xz", Collections.singleton("gz")));
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.tar.deflatez", Collections.singleton("pack200")));
        Assertions.assertThrows(CompressorException.class, () -> this.createCompressorInputStream("bla.tar.zst", Collections.singleton("lz4-framed")));
    }

    @Test
    void testCreateWithAutoDetection() throws Exception {
        try (CompressorInputStream bzip2 = this.createCompressorInputStream("bla.txt.bz2");){
            Assertions.assertNotNull((Object)bzip2);
            Assertions.assertInstanceOf(BZip2CompressorInputStream.class, (Object)bzip2);
        }
        try (CompressorInputStream gzip = this.createCompressorInputStream("bla.tgz");){
            Assertions.assertNotNull((Object)gzip);
            Assertions.assertInstanceOf(GzipCompressorInputStream.class, (Object)gzip);
        }
        try (CompressorInputStream pack200 = this.createCompressorInputStream("bla.pack");){
            Assertions.assertNotNull((Object)pack200);
            Assertions.assertInstanceOf(Pack200CompressorInputStream.class, (Object)pack200);
        }
        try (CompressorInputStream xz = this.createCompressorInputStream("bla.tar.xz");){
            Assertions.assertNotNull((Object)xz);
            Assertions.assertInstanceOf(XZCompressorInputStream.class, (Object)xz);
        }
        try (CompressorInputStream zlib = this.createCompressorInputStream("bla.tar.deflatez");){
            Assertions.assertNotNull((Object)zlib);
            Assertions.assertInstanceOf(DeflateCompressorInputStream.class, (Object)zlib);
        }
        try (CompressorInputStream zstd = this.createCompressorInputStream("bla.tar.zst");){
            Assertions.assertNotNull((Object)zstd);
            Assertions.assertInstanceOf(ZstdCompressorInputStream.class, (Object)zstd);
        }
        Assertions.assertThrows(CompressorException.class, () -> this.factory.createCompressorInputStream((InputStream)new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY)));
    }

    @Test
    void testDetect() throws Exception {
        Assertions.assertEquals((Object)"bzip2", (Object)this.detect("bla.txt.bz2"));
        Assertions.assertEquals((Object)"gz", (Object)this.detect("bla.tgz"));
        Assertions.assertEquals((Object)"pack200", (Object)this.detect("bla.pack"));
        Assertions.assertEquals((Object)"xz", (Object)this.detect("bla.tar.xz"));
        Assertions.assertEquals((Object)"deflate", (Object)this.detect("bla.tar.deflatez"));
        Assertions.assertEquals((Object)"lz4-framed", (Object)this.detect("bla.tar.lz4"));
        Assertions.assertEquals((Object)"lzma", (Object)this.detect("bla.tar.lzma"));
        Assertions.assertEquals((Object)"snappy-framed", (Object)this.detect("bla.tar.sz"));
        Assertions.assertEquals((Object)"z", (Object)this.detect("bla.tar.Z"));
        Assertions.assertEquals((Object)"zstd", (Object)this.detect("bla.tar.zst"));
        Assertions.assertEquals((Object)"z", (Object)this.detect("COMPRESS-386"));
        Assertions.assertEquals((Object)"lzma", (Object)this.detect("COMPRESS-382"));
        Assertions.assertThrows(CompressorException.class, () -> CompressorStreamFactory.detect((InputStream)new BufferedInputStream(new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY))));
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> CompressorStreamFactory.detect(null), (String)"shouldn't be able to detect null stream");
        Assertions.assertEquals((Object)"Stream must not be null.", (Object)e.getMessage());
        CompressorException ce = (CompressorException)Assertions.assertThrows(CompressorException.class, () -> CompressorStreamFactory.detect((InputStream)new BufferedInputStream((InputStream)new BrokenInputStream())), (String)"Expected IOException");
        Assertions.assertEquals((Object)"Failed to read signature.", (Object)ce.getMessage());
    }

    @ParameterizedTest
    @MethodSource(value={"getDetectLimitedByNameParams"})
    void testDetectLimitedByName(String filename, String compressorName) throws Exception {
        Assertions.assertEquals((Object)compressorName, (Object)this.detect(filename, Collections.singleton(compressorName)));
    }

    @Test
    void testDetectLimitedByNameNotFound() throws Exception {
        Set<String> compressorNames = Collections.singleton("deflate");
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.txt.bz2", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tgz", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.pack", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.xz", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.deflatez", Collections.singleton("bzip2")));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.lz4", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.lzma", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.sz", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.Z", compressorNames));
        Assertions.assertThrows(CompressorException.class, () -> this.detect("bla.tar.zst", compressorNames));
    }

    @Test
    void testDetectNullOrEmptyCompressorNames() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CompressorStreamFactory.detect((InputStream)this.createCompressorInputStream("bla.txt.bz2"), (Set)null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CompressorStreamFactory.detect((InputStream)this.createCompressorInputStream("bla.tgz"), new HashSet()));
    }

    @Test
    void testLZMAMemoryLimit() throws Exception {
        Assertions.assertThrows(MemoryLimitException.class, () -> this.createInputStream("COMPRESS-382", 100));
    }

    @Test
    void testMultiples() throws Exception {
        for (int i = 0; i < this.tests.length; ++i) {
            TestData test = this.tests[i];
            CompressorStreamFactory fac = test.factory;
            Assertions.assertNotNull((Object)fac, (String)("Test entry " + i));
            Assertions.assertEquals((Object)test.concat, (Object)fac.getDecompressConcatenated(), (String)("Test entry " + i));
            try (CompressorInputStream in = this.createCompressorInputStream(test.fileName, fac);){
                Assertions.assertNotNull((Object)in, (String)("Test entry " + i));
                for (char entry : test.entryNames) {
                    Assertions.assertEquals((int)entry, (int)in.read(), (String)("Test entry" + i));
                }
                Assertions.assertEquals((int)0, (int)in.available());
                Assertions.assertEquals((int)-1, (int)in.read());
                continue;
            }
        }
    }

    @Test
    void testOverride() {
        CompressorStreamFactory fac1 = new CompressorStreamFactory();
        Assertions.assertFalse((boolean)fac1.getDecompressConcatenated());
        fac1.setDecompressConcatenated(true);
        Assertions.assertTrue((boolean)fac1.getDecompressConcatenated());
        CompressorStreamFactory fac2 = new CompressorStreamFactory(false);
        Assertions.assertFalse((boolean)fac2.getDecompressConcatenated());
        Assertions.assertThrows(IllegalStateException.class, () -> fac2.setDecompressConcatenated(true), (String)"Expected IllegalStateException");
        CompressorStreamFactory fac3 = new CompressorStreamFactory(true);
        Assertions.assertTrue((boolean)fac3.getDecompressConcatenated());
        Assertions.assertThrows(IllegalStateException.class, () -> fac3.setDecompressConcatenated(true), (String)"Expected IllegalStateException");
    }

    @Test
    void testXZMemoryLimitOnRead() throws Exception {
        try (InputStream compressorIs = this.createInputStream("bla.tar.xz", 100);){
            Assertions.assertThrows(MemoryLimitException.class, () -> compressorIs.read());
        }
    }

    @Test
    void testXZMemoryLimitOnSkip() throws Exception {
        try (InputStream compressorIs = this.createInputStream("bla.tar.xz", 100);){
            Assertions.assertThrows(MemoryLimitException.class, () -> compressorIs.skip(10L));
        }
    }

    @Test
    void testZMemoryLimit() throws Exception {
        Assertions.assertThrows(MemoryLimitException.class, () -> this.createInputStream("COMPRESS-386", 100));
    }

    static {
        factorySetTrue.setDecompressConcatenated(true);
        factorySetFalse = new CompressorStreamFactory();
        factorySetFalse.setDecompressConcatenated(false);
    }

    static class TestData {
        final String fileName;
        final char[] entryNames;
        final CompressorStreamFactory factory;
        final boolean concat;

        TestData(String name, char[] names, CompressorStreamFactory factory, boolean concat) {
            this.fileName = name;
            this.entryNames = names;
            this.factory = factory;
            this.concat = concat;
        }
    }
}

