/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurationConverter {
    @Test
    public void testExtendedPropertiesToConfiguration() {
        ExtendedProperties eprops = new ExtendedProperties();
        eprops.setProperty("string", (Object)"teststring");
        eprops.setProperty("int", (Object)"123");
        eprops.addProperty("list", (Object)"item 1");
        eprops.addProperty("list", (Object)"item 2");
        Configuration config = ConfigurationConverter.getConfiguration((ExtendedProperties)eprops);
        Assert.assertEquals((String)"This returns 'teststring'", (Object)"teststring", (Object)config.getString("string"));
        List item1 = config.getList("list");
        Assert.assertEquals((String)"This returns 'item 1'", (Object)"item 1", item1.get(0));
        Assert.assertEquals((String)"This returns 123", (long)123L, (long)config.getInt("int"));
    }

    @Test
    public void testPropertiesToConfiguration() {
        Properties props = new Properties();
        props.setProperty("string", "teststring");
        props.setProperty("int", "123");
        props.setProperty("list", "item 1, item 2");
        Configuration config = ConfigurationConverter.getConfiguration((Properties)props);
        Assert.assertEquals((String)"This returns 'teststring'", (Object)"teststring", (Object)config.getString("string"));
        List item1 = config.getList("list");
        Assert.assertEquals((String)"This returns 'item 1'", (Object)"item 1", item1.get(0));
        Assert.assertEquals((String)"This returns 123", (long)123L, (long)config.getInt("int"));
    }

    @Test
    public void testConfigurationToExtendedProperties() {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("string", (Object)"teststring");
        config.setProperty("int", (Object)"123");
        config.addProperty("list", (Object)"item 1");
        config.addProperty("list", (Object)"item 2");
        ExtendedProperties eprops = ConfigurationConverter.getExtendedProperties((Configuration)config);
        Assert.assertEquals((String)"This returns 'teststring'", (Object)"teststring", (Object)eprops.getString("string"));
        Vector list = eprops.getVector("list");
        Assert.assertEquals((String)"This returns 'item 1'", (Object)"item 1", list.get(0));
        Assert.assertEquals((String)"This returns 123", (long)123L, (long)eprops.getInt("int"));
    }

    @Test
    public void testConfigurationToProperties() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        config.addProperty("array", (Object)"item 1");
        config.addProperty("array", (Object)"item 2");
        config.addProperty("interpolated", (Object)"${string}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        config.addProperty("interpolated-array", (Object)"${interpolated}");
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertNotNull((String)"null properties", (Object)props);
        Assert.assertEquals((String)"'string' property", (Object)"teststring", (Object)props.getProperty("string"));
        Assert.assertEquals((String)"'interpolated' property", (Object)"teststring", (Object)props.getProperty("interpolated"));
        Assert.assertEquals((String)"'array' property", (Object)"item 1,item 2", (Object)props.getProperty("array"));
        Assert.assertEquals((String)"'interpolated-array' property", (Object)"teststring,teststring", (Object)props.getProperty("interpolated-array"));
        config.setListDelimiter(';');
        props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertEquals((String)"'array' property", (Object)"item 1;item 2", (Object)props.getProperty("array"));
    }

    @Test
    public void testConfigurationToPropertiesScalarValue() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("scalar", (Object)new Integer(42));
        Properties props = ConfigurationConverter.getProperties((Configuration)config);
        Assert.assertEquals((String)"Wrong value", (Object)"42", (Object)props.getProperty("scalar"));
    }

    @Test
    public void testConfigurationToMap() {
        BaseConfiguration config = new BaseConfiguration();
        config.addProperty("string", (Object)"teststring");
        Map map = ConfigurationConverter.getMap((Configuration)config);
        Assert.assertNotNull((String)"null map", (Object)map);
        Assert.assertEquals((String)"'string' property", (Object)"teststring", map.get("string"));
    }
}

