/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.dbutils.ProxyFactory;

public class MockResultSet
implements InvocationHandler {
    private Object[] currentRow = null;
    private Iterator<Object[]> iter = null;
    private ResultSetMetaData metaData = null;
    private Boolean wasNull = Boolean.FALSE;

    public static ResultSet create(ResultSetMetaData metaData, Object[][] rows) {
        return ProxyFactory.instance().createResultSet((InvocationHandler)new MockResultSet(metaData, rows));
    }

    public MockResultSet(ResultSetMetaData metaData, Object[][] rows) {
        this.metaData = metaData;
        if (rows == null) {
            List empty = Collections.emptyList();
            this.iter = empty.iterator();
        } else {
            this.iter = Arrays.asList(rows).iterator();
        }
    }

    private int columnIndex(Object[] args) throws SQLException {
        if (args[0] instanceof Integer) {
            return (Integer)args[0];
        }
        if (args[0] instanceof String) {
            return this.columnNameToIndex((String)args[0]);
        }
        throw new SQLException(args[0] + " must be Integer or String");
    }

    private int columnNameToIndex(String columnName) throws SQLException {
        for (int i = 0; i < this.currentRow.length; ++i) {
            int c = i + 1;
            if (!this.metaData.getColumnName(c).equalsIgnoreCase(columnName)) continue;
            return c;
        }
        throw new SQLException(columnName + " is not a valid column name.");
    }

    protected Object getBoolean(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Boolean.FALSE : Boolean.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected Object getByte(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Byte.valueOf((byte)0) : Byte.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected Object getDouble(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Double.valueOf(0.0) : Double.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected Object getFloat(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Float.valueOf(0.0f) : Float.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected Object getInt(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Integer.valueOf(0) : Integer.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected Object getLong(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Long.valueOf(0L) : Long.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    protected Object getObject(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        return obj;
    }

    protected Object getShort(int columnIndex) throws SQLException {
        Object obj = this.currentRow[columnIndex - 1];
        this.setWasNull(obj);
        try {
            return obj == null ? Short.valueOf((short)0) : Short.valueOf(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    protected String getString(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        this.setWasNull(obj);
        return obj == null ? null : obj.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getMetaData")) {
            return this.getMetaData();
        }
        if (methodName.equals("next")) {
            return this.next();
        }
        if (!methodName.equals("previous") && !methodName.equals("close")) {
            if (methodName.equals("getBoolean")) {
                return this.getBoolean(this.columnIndex(args));
            }
            if (methodName.equals("getByte")) {
                return this.getByte(this.columnIndex(args));
            }
            if (methodName.equals("getDouble")) {
                return this.getDouble(this.columnIndex(args));
            }
            if (methodName.equals("getFloat")) {
                return this.getFloat(this.columnIndex(args));
            }
            if (methodName.equals("getInt")) {
                return this.getInt(this.columnIndex(args));
            }
            if (methodName.equals("getLong")) {
                return this.getLong(this.columnIndex(args));
            }
            if (methodName.equals("getObject")) {
                return this.getObject(this.columnIndex(args));
            }
            if (methodName.equals("getShort")) {
                return this.getShort(this.columnIndex(args));
            }
            if (methodName.equals("getString")) {
                return this.getString(this.columnIndex(args));
            }
            if (methodName.equals("wasNull")) {
                return this.wasNull();
            }
            if (methodName.equals("isLast")) {
                return this.isLast();
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (methodName.equals("toString")) {
                return "MockResultSet " + System.identityHashCode(proxy);
            }
            if (methodName.equals("equals")) {
                return proxy == args[0];
            }
        }
        throw new UnsupportedOperationException("Unsupported method: " + methodName);
    }

    protected Boolean isLast() throws SQLException {
        return this.iter.hasNext() ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Boolean next() throws SQLException {
        if (!this.iter.hasNext()) {
            return Boolean.FALSE;
        }
        this.currentRow = this.iter.next();
        return Boolean.TRUE;
    }

    private void setWasNull(Object isNull) {
        this.wasNull = isNull == null ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

