/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.openjpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.commons.jcs3.jcache.openjpa.OpenJPAJCacheDataCache;
import org.apache.commons.jcs3.jcache.openjpa.OpenJPAJCacheDataCacheManager;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OpenJPAJCacheDataCacheTest {
    private static final Properties props = new Properties(){
        {
            this.setProperty("openjpa.MetaDataFactory", "jpa(Types=" + MyEntity.class.getName() + ")");
            this.setProperty("openjpa.ConnectionDriverName", EmbeddedDriver.class.getName());
            this.setProperty("openjpa.ConnectionURL", "jdbc:derby:memory:test;create=true");
            this.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema");
            this.setProperty("openjpa.DataCacheManager", "jcache");
            this.setProperty("openjpa.RuntimeUnenhancedClasses", "supported");
        }
    };

    @Test
    public void entity() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"test-jcache", (Map)props);
        OpenJPAConfiguration conf = ((OpenJPAEntityManagerFactorySPI)OpenJPAEntityManagerFactorySPI.class.cast(emf)).getConfiguration();
        EntityManager em = emf.createEntityManager();
        MyEntity entity = new MyEntity();
        entity.setName("cacheMe1");
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        Assert.assertNotNull((Object)conf.getDataCacheManagerInstance().getDataCache("default"));
        Assert.assertThat((Object)conf.getDataCacheManagerInstance(), (Matcher)CoreMatchers.instanceOf(OpenJPAJCacheDataCacheManager.class));
        Assert.assertThat((Object)conf.getDataCacheManagerInstance().getDataCache("default"), (Matcher)CoreMatchers.instanceOf(OpenJPAJCacheDataCache.class));
        Assert.assertTrue((boolean)conf.getDataCacheManagerInstance().getDataCache("default").contains(JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)conf.getMetaDataRepositoryInstance().getCachedMetaData(MyEntity.class), (Object)entity.getId())));
        em.close();
        emf.close();
    }

    @Test
    public void query() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"test-jcache", (Map)props);
        OpenJPAConfiguration conf = ((OpenJPAEntityManagerFactorySPI)OpenJPAEntityManagerFactorySPI.class.cast(emf)).getConfiguration();
        EntityManager em = emf.createEntityManager();
        final MyEntity entity = new MyEntity();
        entity.setName("cacheMe1");
        em.getTransaction().begin();
        em.persist((Object)entity);
        em.getTransaction().commit();
        Query query = em.createQuery("select e from OpenJPAJCacheDataCacheTest$MyEntity e where e.id = :id");
        Assert.assertEquals((long)1L, (long)query.setParameter("id", (Object)entity.getId()).getResultList().size());
        Assert.assertNotNull((Object)conf.getDataCacheManagerInstance().getDataCache("default"));
        Assert.assertThat((Object)conf.getDataCacheManagerInstance(), (Matcher)CoreMatchers.instanceOf(OpenJPAJCacheDataCacheManager.class));
        Assert.assertThat((Object)conf.getDataCacheManagerInstance().getDataCache("default"), (Matcher)CoreMatchers.instanceOf(OpenJPAJCacheDataCache.class));
        Assert.assertTrue((boolean)conf.getDataCacheManagerInstance().getDataCache("default").contains(JPAFacadeHelper.toOpenJPAObjectId((ClassMetaData)conf.getMetaDataRepositoryInstance().getCachedMetaData(MyEntity.class), (Object)entity.getId())));
        HashMap<Object, Object> args = new HashMap<Object, Object>(){
            {
                this.put("id", entity.getId());
            }
        };
        QueryKey qk = QueryKey.newInstance((org.apache.openjpa.kernel.Query)((org.apache.openjpa.kernel.Query)query.unwrap(org.apache.openjpa.kernel.Query.class)), (Map)args);
        Assert.assertNotNull((Object)conf.getDataCacheManagerInstance().getSystemQueryCache().get(qk));
        em.close();
        emf.close();
    }

    @Entity
    public static class MyEntity {
        @Id
        @GeneratedValue
        private long id;
        private String name;

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

