/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.HsqlSetupTableUtil;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.hsqldb.jdbcDriver;

public class JDBCDiskCacheSharedPoolUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestJDBCDiskCacheSharedPool.ccf");
    }

    public void testSimpleJDBCPutGetWithHSQL() throws Exception {
        System.setProperty("hsqldb.cache_scale", "8");
        String rafroot = "target";
        Properties p = new Properties();
        String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = p.getProperty("url", "jdbc:hsqldb:");
        String database = p.getProperty("database", "target/cache_hsql_db_sharedpool");
        String user = p.getProperty("user", "sa");
        String password = p.getProperty("password", "");
        new jdbcDriver();
        Class.forName(driver).newInstance();
        Connection cConn = DriverManager.getConnection(url + database, user, password);
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE_0");
        HsqlSetupTableUtil.setupTABLE(cConn, "JCS_STORE_1");
        this.runTestForRegion("testCache1", 200);
    }

    public void runTestForRegion(String region, int items) throws Exception {
        int i;
        int i2;
        CacheAccess jcs = JCS.getInstance((String)region);
        for (i2 = 0; i2 <= items; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)(region + " data " + i2));
        }
        Thread.sleep(1000L);
        for (i2 = 0; i2 <= items; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            JDBCDiskCacheSharedPoolUnitTest.assertEquals((String)("key = [" + i2 + ":key] value = [" + value + "]"), (String)(region + " data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= items; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= items; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            JDBCDiskCacheSharedPoolUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            JDBCDiskCacheSharedPoolUnitTest.assertEquals((String)("value " + i + ":key"), (String)(region + " data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= items; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= items; ++i) {
            JDBCDiskCacheSharedPoolUnitTest.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }
}

