/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.fmt;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.tags.fmt.SetLocaleTag;
import org.apache.commons.jelly.tags.fmt.TimeZoneTag;
import org.xml.sax.SAXException;

public class FormatDateTag
extends TagSupport {
    private static final String DEFAULT = "default";
    private static final String SHORT = "short";
    private static final String MEDIUM = "medium";
    private static final String LONG = "long";
    private static final String FULL = "full";
    private static final String DATE = "date";
    private static final String TIME = "time";
    private static final String DATETIME = "both";
    private Expression value;
    private Expression type;
    private Expression dateStyle;
    private Expression timeStyle;
    private Expression pattern;
    private Expression timeZone;
    private String var;
    private String scope;
    private String etype;
    private String edateStyle;
    private String etimeStyle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doTag(XMLOutput output) throws JellyTagException {
        if (this.scope != null && this.var == null) {
            throw new JellyTagException("If 'scope' is specified, 'var' must be defined for this tag");
        }
        Object valueInput = null;
        if (this.value != null) {
            valueInput = this.value.evaluate(this.context);
        }
        Date date = null;
        if (valueInput != null && valueInput instanceof Date) {
            date = (Date)valueInput;
        }
        if (date == null && this.var != null) {
            if (this.scope != null) {
                this.context.removeVariable(this.var, this.scope);
            } else {
                this.context.removeVariable(this.var);
            }
        }
        this.etype = DATE;
        if (this.type != null) {
            this.etype = (String)this.type.evaluate(this.context);
        }
        this.edateStyle = DEFAULT;
        if (this.dateStyle != null) {
            this.edateStyle = (String)this.dateStyle.evaluate(this.context);
        }
        this.etimeStyle = DEFAULT;
        if (this.timeStyle != null) {
            this.etimeStyle = (String)this.timeStyle.evaluate(this.context);
        }
        String epattern = null;
        if (this.pattern != null) {
            epattern = (String)this.pattern.evaluate(this.context);
        }
        Object etimeZone = null;
        if (this.timeZone != null) {
            etimeZone = this.timeZone.evaluate(this.context);
        }
        Locale locale = SetLocaleTag.getFormattingLocale(this.context, (Tag)this, true, DateFormat.getAvailableLocales());
        String formatted = null;
        if (locale != null) {
            DateFormat formatter = this.createFormatter(locale);
            if (this.pattern != null) {
                try {
                    ((SimpleDateFormat)formatter).applyPattern(epattern);
                }
                catch (ClassCastException cce) {
                    formatter = new SimpleDateFormat(epattern, locale);
                }
            }
            TimeZone tz = null;
            if (etimeZone instanceof String && ((String)etimeZone).equals("")) {
                etimeZone = null;
            }
            if (etimeZone != null) {
                if (etimeZone instanceof String) {
                    tz = TimeZone.getTimeZone((String)etimeZone);
                } else {
                    if (!(etimeZone instanceof TimeZone)) throw new JellyTagException("Bad time zone");
                    tz = (TimeZone)etimeZone;
                }
            } else {
                tz = TimeZoneTag.getTimeZone(this.context, (Tag)this);
            }
            if (tz != null) {
                formatter.setTimeZone(tz);
            }
            formatted = formatter.format(date);
        } else {
            formatted = date.toString();
        }
        if (this.var != null) {
            if (this.scope != null) {
                this.context.setVariable(this.var, this.scope, (Object)formatted);
                return;
            } else {
                this.context.setVariable(this.var, (Object)formatted);
            }
            return;
        }
        try {
            output.write(formatted);
            return;
        }
        catch (SAXException e) {
            throw new JellyTagException("could not write formatted text", (Throwable)e);
        }
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public void setType(Expression type) {
        this.type = type;
    }

    public void setDateStyle(Expression dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setTimeStyle(Expression timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setPattern(Expression pattern) {
        this.pattern = pattern;
    }

    public void setTimeZone(Expression timeZone) {
        this.timeZone = timeZone;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    private DateFormat createFormatter(Locale loc) throws JellyTagException {
        DateFormat formatter = null;
        if (this.etype == null || DATE.equalsIgnoreCase(this.etype)) {
            formatter = DateFormat.getDateInstance(FormatDateTag.getStyle(this.edateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), loc);
        } else if (TIME.equalsIgnoreCase(this.etype)) {
            formatter = DateFormat.getTimeInstance(FormatDateTag.getStyle(this.etimeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), loc);
        } else if (DATETIME.equalsIgnoreCase(this.etype)) {
            formatter = DateFormat.getDateTimeInstance(FormatDateTag.getStyle(this.edateStyle, "FORMAT_DATE_INVALID_DATE_STYLE"), FormatDateTag.getStyle(this.etimeStyle, "FORMAT_DATE_INVALID_TIME_STYLE"), loc);
        } else {
            throw new JellyTagException("Date format invalue");
        }
        return formatter;
    }

    public static int getStyle(String style, String errCode) throws JellyTagException {
        int ret = 2;
        if (style != null) {
            if (DEFAULT.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (SHORT.equalsIgnoreCase(style)) {
                ret = 3;
            } else if (MEDIUM.equalsIgnoreCase(style)) {
                ret = 2;
            } else if (LONG.equalsIgnoreCase(style)) {
                ret = 1;
            } else if (FULL.equalsIgnoreCase(style)) {
                ret = 0;
            } else {
                throw new JellyTagException("Invalid style " + errCode);
            }
        }
        return ret;
    }
}

