/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.XSAllCM;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;

    public CMBuilder() {
        this.fDeclPool = null;
    }

    public CMBuilder(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public void setDeclPool(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl xSComplexTypeDecl) {
        short s = xSComplexTypeDecl.getContentType();
        if (s == 1 || s == 0) {
            return null;
        }
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (xSParticleDecl == null) {
            return fEmptyCM;
        }
        XSCMValidator xSCMValidator = null;
        xSCMValidator = xSParticleDecl.fType == 3 && ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor == 103 ? this.createAllCM(xSParticleDecl) : this.createDFACM(xSParticleDecl);
        if (xSCMValidator == null) {
            xSCMValidator = fEmptyCM;
        }
        return xSCMValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        XSAllCM xSAllCM = new XSAllCM(xSParticleDecl.fMinOccurs == 0, xSModelGroupImpl.fParticleCount);
        int n = 0;
        while (n < xSModelGroupImpl.fParticleCount) {
            if (xSModelGroupImpl.fParticles[n].fType != 0 && xSModelGroupImpl.fParticles[n].fMaxOccurs != 0) {
                xSAllCM.addElement((XSElementDecl)xSModelGroupImpl.fParticles[n].fValue, xSModelGroupImpl.fParticles[n].fMinOccurs == 0);
            }
            ++n;
        }
        return xSAllCM;
    }

    XSCMValidator createDFACM(XSParticleDecl xSParticleDecl) {
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode = this.buildSyntaxTree(xSParticleDecl);
        if (cMNode == null) {
            return null;
        }
        return new XSDFACM(cMNode, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl xSParticleDecl) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        short s = xSParticleDecl.fType;
        CMNode cMNode = null;
        if (s == 2 || s == 1) {
            cMNode = new XSCMLeaf(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.expandContentModel(cMNode, n2, n);
        } else if (s == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            CMNode cMNode2 = null;
            boolean bl = false;
            int n3 = 0;
            while (n3 < xSModelGroupImpl.fParticleCount) {
                cMNode2 = this.buildSyntaxTree(xSModelGroupImpl.fParticles[n3]);
                if (cMNode2 != null) {
                    if (cMNode == null) {
                        cMNode = cMNode2;
                    } else {
                        cMNode = new XSCMBinOp(xSModelGroupImpl.fCompositor, cMNode, cMNode2);
                        bl = true;
                    }
                }
                ++n3;
            }
            if (cMNode != null) {
                if (xSModelGroupImpl.fCompositor == 101 && !bl && xSModelGroupImpl.fParticleCount > 1) {
                    cMNode = new XSCMUniOp(5, cMNode);
                }
                cMNode = this.expandContentModel(cMNode, n2, n);
            }
        }
        return cMNode;
    }

    private CMNode expandContentModel(CMNode cMNode, int n, int n2) {
        CMNode cMNode2;
        block5: {
            int n3;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                cMNode2 = null;
                                if (n != 1 || n2 != 1) break block4;
                                cMNode2 = cMNode;
                                break block5;
                            }
                            if (n != 0 || n2 != 1) break block6;
                            cMNode2 = new XSCMUniOp(5, cMNode);
                            break block5;
                        }
                        if (n != 0 || n2 != -1) break block7;
                        cMNode2 = new XSCMUniOp(4, cMNode);
                        break block5;
                    }
                    if (n != 1 || n2 != -1) break block8;
                    cMNode2 = new XSCMUniOp(6, cMNode);
                    break block5;
                }
                if (n2 != -1) break block9;
                cMNode2 = new XSCMUniOp(6, cMNode);
                int n4 = 0;
                while (n4 < n - 1) {
                    cMNode2 = new XSCMBinOp(102, this.copyNode(cMNode), cMNode2);
                    ++n4;
                }
                break block5;
            }
            if (n > 0) {
                cMNode2 = cMNode;
                n3 = 0;
                while (n3 < n - 1) {
                    cMNode2 = new XSCMBinOp(102, cMNode2, this.copyNode(cMNode));
                    ++n3;
                }
            }
            if (n2 <= n) break block5;
            cMNode = new XSCMUniOp(5, cMNode);
            cMNode2 = cMNode2 == null ? cMNode : new XSCMBinOp(102, cMNode2, this.copyNode(cMNode));
            n3 = n;
            while (n3 < n2 - 1) {
                cMNode2 = new XSCMBinOp(102, cMNode2, this.copyNode(cMNode));
                ++n3;
            }
        }
        return cMNode2;
    }

    private CMNode copyNode(CMNode cMNode) {
        int n = cMNode.type();
        if (n == 101 || n == 102) {
            XSCMBinOp xSCMBinOp = (XSCMBinOp)cMNode;
            cMNode = new XSCMBinOp(n, this.copyNode(xSCMBinOp.getLeft()), this.copyNode(xSCMBinOp.getRight()));
        } else if (n == 4 || n == 6 || n == 5) {
            XSCMUniOp xSCMUniOp = (XSCMUniOp)cMNode;
            cMNode = new XSCMUniOp(n, this.copyNode(xSCMUniOp.getChild()));
        } else if (n == 1 || n == 2) {
            XSCMLeaf xSCMLeaf = (XSCMLeaf)cMNode;
            cMNode = new XSCMLeaf(xSCMLeaf.type(), xSCMLeaf.getLeaf(), xSCMLeaf.getParticleId(), this.fLeafCount++);
        }
        return cMNode;
    }
}

