/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.engine;

import com.googlecode.clearnlp.dependency.DEPParser;
import com.googlecode.clearnlp.dependency.srl.SRLabeler;
import com.googlecode.clearnlp.engine.AbstractEngine;
import com.googlecode.clearnlp.engine.EngineLib;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.PredIdentifier;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class EngineSetter
implements EngineLib {
    public static void saveModel(String modelFile, String featureXml, AbstractEngine engine) throws Exception {
        JarArchiveOutputStream zout = new JarArchiveOutputStream((OutputStream)new FileOutputStream(modelFile));
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("FEATURE"));
        IOUtils.copy((InputStream)new FileInputStream(featureXml), (OutputStream)zout);
        zout.closeArchiveEntry();
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("MODEL"));
        PrintStream fout = new PrintStream(new BufferedOutputStream((OutputStream)zout));
        engine.saveModel(fout);
        fout.close();
        zout.closeArchiveEntry();
        zout.close();
    }

    public static void setPOSTaggers(String modelFile, String featureXml, POSTagger[] taggers, double threshold, int modelSize) throws Exception {
        JarArchiveOutputStream zout = new JarArchiveOutputStream((OutputStream)new FileOutputStream(modelFile));
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("CONFIGURATION"));
        PrintStream fout = new PrintStream((OutputStream)zout);
        fout.println(modelSize);
        fout.println(threshold);
        fout.close();
        zout.closeArchiveEntry();
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("FEATURE"));
        IOUtils.copy((InputStream)new FileInputStream(featureXml), (OutputStream)zout);
        zout.closeArchiveEntry();
        for (int modId = 0; modId < modelSize; ++modId) {
            zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("MODEL" + modId));
            fout = new PrintStream(new BufferedOutputStream((OutputStream)zout));
            taggers[modId].saveModel(fout);
            fout.close();
            zout.closeArchiveEntry();
        }
        zout.close();
    }

    public static void setDEPParser(String modelFile, String featureXml, DEPParser parser) throws Exception {
        EngineSetter.saveModel(modelFile, featureXml, parser);
    }

    public static void setPredIdentifier(String modelFile, String featureXml, PredIdentifier identifier) throws Exception {
        EngineSetter.saveModel(modelFile, featureXml, identifier);
    }

    public static void setSRLabeler(String modelFile, String featureXml, SRLabeler parser) throws Exception {
        JarArchiveOutputStream zout = new JarArchiveOutputStream((OutputStream)new FileOutputStream(modelFile));
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("FEATURE"));
        IOUtils.copy((InputStream)new FileInputStream(featureXml), (OutputStream)zout);
        zout.closeArchiveEntry();
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("SET_DOWN"));
        PrintStream fout = new PrintStream(new BufferedOutputStream((OutputStream)zout));
        parser.saveDownSet(fout);
        fout.close();
        zout.closeArchiveEntry();
        zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("SET_UP"));
        fout = new PrintStream(new BufferedOutputStream((OutputStream)zout));
        parser.saveUpSet(fout);
        fout.close();
        zout.closeArchiveEntry();
        for (int modId = 0; modId < 2; ++modId) {
            zout.putArchiveEntry((ArchiveEntry)new JarArchiveEntry("MODEL" + modId));
            fout = new PrintStream(new BufferedOutputStream((OutputStream)zout));
            parser.saveModel(fout, modId);
            fout.close();
            zout.closeArchiveEntry();
        }
        zout.close();
    }
}

