/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.headrule;

import com.googlecode.clearnlp.headrule.HeadRule;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class HeadRuleMap
extends HashMap<String, HeadRule> {
    public static final String DELIM_COLUMN = "\t";

    public HeadRuleMap(BufferedReader fin) {
        try {
            String line;
            while ((line = fin.readLine()) != null) {
                String[] tmp = line.split(DELIM_COLUMN);
                String pTag = tmp[0];
                String dir = tmp[1];
                String rule = tmp[2];
                this.put(pTag, new HeadRule(dir, this.getTagSets(rule)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[][] getTagSets(String rule) {
        String[] sets = rule.split(";");
        int size = sets.length;
        String[][] tagsets = new String[size][];
        for (int i = 0; i < size; ++i) {
            tagsets[i] = sets[i].split("\\|");
        }
        return tagsets;
    }

    @Override
    public String toString() {
        StringBuilder build = new StringBuilder();
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            build.append(key);
            build.append(DELIM_COLUMN);
            HeadRule rule = (HeadRule)this.get(key);
            if (rule.isRightToLeft()) {
                build.append("r");
            } else {
                build.append("l");
            }
            build.append(DELIM_COLUMN);
            build.append(rule.toString());
            build.append("\n");
        }
        return build.toString().trim();
    }
}

