/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank.verbnet;

import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.propbank.verbnet.PVRoleset;
import com.googlecode.clearnlp.propbank.verbnet.PVVerb;
import com.googlecode.clearnlp.util.UTXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PVMap
extends HashMap<String, PVVerb> {
    public static final String VERB_EXT = "-v.xml";
    public static final String E_PBVNMAP = "pbvnmap";
    public static final String E_FRAMESET = "frameset";
    public static final String E_VERB = "verb";
    public static final String E_ROLESET = "roleset";
    public static final String E_ROLES = "roles";
    public static final String E_ROLE = "role";
    public static final String E_VNROLE = "vnrole";

    public PVMap(InputStream in) {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element ePVMap = (Element)doc.getElementsByTagName(E_PBVNMAP).item(0);
            NodeList list = ePVMap.getElementsByTagName(E_VERB);
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                String lemma;
                Element eVerb = (Element)list.item(i);
                PVVerb pvVerb = new PVVerb(eVerb, lemma = UTXml.getTrimmedAttribute(eVerb, "lemma"), true);
                if (pvVerb.isEmpty()) continue;
                this.put(lemma, pvVerb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PVMap(String framesetDir) {
        try {
            String[] filelist = new File(framesetDir).list(new FileExtFilter(VERB_EXT));
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            for (String framesetFile : filelist) {
                String lemma;
                Document doc = builder.parse(new FileInputStream(framesetDir + File.separator + framesetFile));
                Element eFrameset = (Element)doc.getElementsByTagName(E_FRAMESET).item(0);
                PVVerb pvVerb = new PVVerb(eFrameset, lemma = framesetFile.substring(0, framesetFile.length() - VERB_EXT.length()), false);
                if (pvVerb.isEmpty()) continue;
                this.put(lemma, pvVerb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PVRoleset getRoleset(String rolesetId) {
        String lemma = rolesetId.substring(0, rolesetId.lastIndexOf("."));
        PVVerb pvVerb = (PVVerb)this.get(lemma);
        return pvVerb != null ? (PVRoleset)pvVerb.get(rolesetId) : null;
    }

    public void print(PrintStream out) {
        out.println(UTXml.startsElement(false, E_PBVNMAP, new String[0]));
        ArrayList lemmas = new ArrayList(this.keySet());
        Collections.sort(lemmas);
        for (String lemma : lemmas) {
            out.println(this.get(lemma));
        }
        out.println(UTXml.endsElement(E_PBVNMAP));
    }
}

