/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.util;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UTXml {
    public static Element getFirstElementByTagName(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        return list.getLength() > 0 ? (Element)list.item(0) : null;
    }

    public static String getTrimmedAttribute(Element element, String name) {
        return element.getAttribute(name).trim();
    }

    public static String getTrimmedTextContent(Element element) {
        return element.getTextContent().trim();
    }

    public static Element getDocumentElement(InputStream fin) {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            Document doc = builder.parse(fin);
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            System.exit(1);
            return null;
        }
    }

    public static String startsElement(boolean isClosed, String element, String ... attributes) {
        StringBuilder build = new StringBuilder();
        int size = attributes.length;
        build.append("<");
        build.append(element);
        for (int i = 0; i < size; i += 2) {
            String key = attributes[i];
            String val = attributes[i + 1];
            build.append(" ");
            build.append(key);
            build.append("=\"");
            build.append(val);
            build.append("\"");
        }
        if (isClosed) {
            build.append("/>");
        } else {
            build.append(">");
        }
        return build.toString();
    }

    public static String endsElement(String element) {
        StringBuilder build = new StringBuilder();
        build.append("</");
        build.append(element);
        build.append(">");
        return build.toString();
    }

    public static String getTemplate(String element, String contents, String indent, String ... attributes) {
        StringBuilder build = new StringBuilder();
        build.append(indent);
        build.append(UTXml.startsElement(false, element, attributes));
        build.append("\n");
        build.append(contents);
        build.append("\n");
        build.append(indent);
        build.append(UTXml.endsElement(element));
        return build.toString();
    }
}

