/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.CmdLineTools;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Tools.CmdLineTools.NormHelp;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.In;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class norm
extends SystemOption {
    private static final String NO_OUTPUT_STR = "-No Output-";
    private boolean detailsFlag_ = false;
    private boolean runFlag_ = true;
    private boolean noOutputFlag_ = false;
    private boolean promptFlag_ = false;
    private boolean filterInputFlag_ = false;
    private boolean fileOutput_ = false;
    private int maxTerm_ = -1;
    private int termFieldNum_ = 1;
    private String noOutputStr_ = "-No Output-";
    private String separator_ = "|";
    private String configFile_ = null;
    private String promptStr_ = null;
    private Vector<String> stopWords_ = null;
    private Hashtable<Character, String> symbolMap_ = null;
    private Hashtable<Character, String> unicodeMap_ = null;
    private Hashtable<Character, Character> diacriticMap_ = null;
    private Hashtable<Character, String> ligatureMap_ = null;
    private Hashtable<Character, String> nonStripMap_ = null;
    private RTrieTree removeSTree_ = null;
    private Connection conn_ = null;
    private RamTrie trie_ = null;
    private Configuration conf_ = null;
    private BufferedReader inReader_ = null;
    private BufferedWriter outWriter_ = null;

    public norm() {
        this.Init();
    }

    public static void main(String[] args) {
        Option io = Option.GetOptonByArgs(args);
        norm normObj = new norm();
        Out out = new Out();
        if (SystemOption.CheckSyntax(io, normObj.GetOption(), false, true)) {
            normObj.ExecuteCommands(io, normObj.GetOption(), out);
            normObj.GetConfig();
            normObj.InitByConfig(normObj, out);
        } else {
            NormHelp.NormHelp(normObj.GetOutWriter(), normObj.GetFileOutput(), out);
        }
        normObj.Close();
    }

    public void GetVariants(Out out) {
        if (this.inReader_ == null) {
            try {
                this.inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            catch (IOException e) {
                System.err.println("**Error: problem of reading std-in");
            }
        }
        int minTermLen = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = this.conf_.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(this.conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        try {
            this.conn_ = DbBase.OpenConnection(this.conf_);
            this.trie_ = new RamTrie(true, minTermLen, lvgDir, minTrieStemLength);
            do {
                if (!this.promptFlag_) continue;
                this.GetPrompt(out);
            } while (this.LineHandler(this.inReader_.readLine(), out));
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption, Out out) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (norm.CheckOption(nameItem, "-ci")) {
            try {
                Configuration conf;
                boolean useClassPath = false;
                String configFile = this.configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lvg";
                }
                if ((conf = this.conf_) == null) {
                    conf = new Configuration(configFile, useClassPath);
                }
                out.Println(this.outWriter_, conf.GetInformation(), this.fileOutput_, false);
            }
            catch (IOException useClassPath) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-d")) {
            this.detailsFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-h")) {
            NormHelp.NormHelp(this.outWriter_, this.fileOutput_, out);
            this.runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    this.inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (norm.CheckOption(nameItem, "-n")) {
            this.noOutputFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    this.fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (norm.CheckOption(nameItem, "-p")) {
            this.promptFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-s:STR")) {
            this.separator_ = nameItem.GetOptionArgument();
            if (this.separator_.equals("\\t")) {
                this.separator_ = new Character('\t').toString();
            }
        } else if (norm.CheckOption(nameItem, "-t:INT")) {
            this.termFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (norm.CheckOption(nameItem, "-ti")) {
            this.filterInputFlag_ = true;
        } else if (norm.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "norm.2016";
                out.Println(this.outWriter_, releaseStr, this.fileOutput_, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (norm.CheckOption(nameItem, "-x:STR")) {
            this.configFile_ = nameItem.GetOptionArgument();
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-ci -d -h -hs -i:STR -n -o:STR -p -s:STR -t:INT -ti -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-ci", "Print_Config_Info");
        this.systemOption_.SetFlagFullName("-d", "Print_Operation_Details");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-s", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Term_Field");
        this.systemOption_.SetFlagFullName("-ti", "Display_Filtered_Input");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x", "Load_Configuration_file");
    }

    private void Close() {
        try {
            if (this.outWriter_ != null) {
                this.outWriter_.close();
            }
            if (this.inReader_ != null) {
                this.inReader_.close();
            }
            if (this.conn_ != null) {
                DbBase.CloseConnection(this.conn_, this.conf_);
            }
        }
        catch (Exception e) {
            System.err.println("Err@norm.Close(): " + e.toString());
        }
    }

    private void GetPrompt(Out out) throws IOException {
        out.Println(this.outWriter_, this.promptStr_, this.fileOutput_, false);
    }

    private boolean LineHandler(String line, Out out) throws SQLException, IOException {
        if (line == null) {
            return false;
        }
        String inTerm = In.GetField(line, this.separator_, this.termFieldNum_);
        LexItem in = new LexItem(inTerm);
        Vector<LexItem> result = ToNormalize.Mutate(in, this.maxTerm_, this.stopWords_, this.conn_, this.trie_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, this.detailsFlag_, false);
        if (this.noOutputFlag_ && (result.size() == 0 || result.size() == 1 && result.elementAt(0).GetTargetTerm().length() == 0)) {
            String outStr = line;
            if (this.filterInputFlag_) {
                outStr = in.GetOriginalTerm();
            }
            out.Println(this.outWriter_, outStr + this.separator_ + this.noOutputStr_, this.fileOutput_, false);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                LexItem temp = result.elementAt(i);
                String outStr = line;
                if (this.filterInputFlag_) {
                    outStr = temp.GetOriginalTerm();
                }
                out.Println(this.outWriter_, outStr + this.separator_ + temp.GetTargetTerm(), this.fileOutput_, false);
                if (!this.detailsFlag_) continue;
                out.Println(this.outWriter_, temp.GetDetailInformation(), this.fileOutput_, false);
            }
        }
        return true;
    }

    private boolean GetFileOutput() {
        return this.fileOutput_;
    }

    private BufferedWriter GetOutWriter() {
        return this.outWriter_;
    }

    private void Init() {
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        try {
            this.outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Err@norm: problem of opening Std-out.");
        }
    }

    private void GetConfig() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        if (this.conf_ == null) {
            this.conf_ = new Configuration(this.configFile_, useClassPath);
        }
    }

    private void InitByConfig(norm normObj, Out out) {
        if (this.conf_.GetSize() <= 0) {
            this.runFlag_ = false;
        } else {
            if (this.maxTerm_ == -1) {
                this.maxTerm_ = Integer.parseInt(this.conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
            }
            if (this.conf_.GetConfiguration("NO_OUTPUT") != null) {
                this.noOutputStr_ = this.conf_.GetConfiguration("NO_OUTPUT");
            }
            if (this.stopWords_ == null) {
                this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
            }
            if (this.symbolMap_ == null) {
                this.symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(this.conf_);
            }
            if (this.unicodeMap_ == null) {
                this.unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(this.conf_);
            }
            if (this.diacriticMap_ == null) {
                this.diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(this.conf_);
            }
            if (this.ligatureMap_ == null) {
                this.ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(this.conf_);
            }
            if (this.nonStripMap_ == null) {
                this.nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(this.conf_);
            }
            if (this.removeSTree_ == null) {
                this.removeSTree_ = ToRemoveS.GetRTrieTreeFromFile(this.conf_);
            }
            if (!this.conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                this.promptStr_ = this.conf_.GetConfiguration("LVG_PROMPT");
            }
            if (this.runFlag_) {
                normObj.GetVariants(out);
            }
        }
    }
}

