/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpInput<T>
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = Log.getLogger(HttpInput.class);
    private HttpChannelState _channelState;
    private Throwable _onError;
    private ReadListener _listener;
    private boolean _notReady;
    protected State _state = BLOCKING;
    private State _eof = null;
    private final Object _lock;
    protected static final State BLOCKING = new State(){

        @Override
        public void waitForContent(HttpInput<?> in) throws IOException {
            in.blockForContent();
        }

        public String toString() {
            return "OPEN";
        }
    };
    protected static final State ASYNC = new State(){

        @Override
        public int noContent() throws IOException {
            return 0;
        }

        public String toString() {
            return "ASYNC";
        }
    };
    protected static final State EARLY_EOF = new State(){

        @Override
        public int noContent() throws IOException {
            throw new EofException();
        }

        @Override
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "EARLY_EOF";
        }
    };
    protected static final State EOF = new State(){

        @Override
        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "EOF";
        }
    };

    protected HttpInput() {
        this(null);
    }

    protected HttpInput(Object lock) {
        this._lock = lock == null ? this : lock;
    }

    public final Object lock() {
        return this._lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.lock();
        synchronized (object) {
            this._state = BLOCKING;
            this._eof = null;
            this._onError = null;
        }
    }

    protected abstract T nextContent() throws IOException;

    protected T getNextContent() throws IOException {
        T content = this.nextContent();
        if (content == null && this._eof != null) {
            LOG.debug("{} eof {}", new Object[]{this, this._eof});
            this._state = this._eof;
            this._eof = null;
        }
        return content;
    }

    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes, 0, 1);
        return read < 0 ? -1 : 0xFF & bytes[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        try {
            Object object = this.lock();
            synchronized (object) {
                T item = this.getNextContent();
                return item == null ? 0 : this.remaining(item);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        T item = null;
        Object object = this.lock();
        synchronized (object) {
            item = this.getNextContent();
            if (item == null) {
                this._state.waitForContent(this);
                item = this.getNextContent();
                if (item == null) {
                    return this._state.noContent();
                }
            }
        }
        return this.get(item, b, off, len);
    }

    protected abstract int remaining(T var1);

    protected abstract int get(T var1, byte[] var2, int var3, int var4);

    protected abstract void consume(T var1, int var2);

    protected abstract void blockForContent() throws IOException;

    protected boolean onAsyncRead() {
        if (this._listener == null) {
            return false;
        }
        this._channelState.onReadPossible();
        return true;
    }

    public abstract void content(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void earlyEOF() {
        Object object = this.lock();
        synchronized (object) {
            if (this._eof == null || !this._eof.isEOF()) {
                LOG.debug("{} early EOF", new Object[]{this});
                this._eof = EARLY_EOF;
                if (this._listener != null) {
                    this._channelState.onReadPossible();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageComplete() {
        Object object = this.lock();
        synchronized (object) {
            if (this._eof == null || !this._eof.isEOF()) {
                LOG.debug("{} EOF", new Object[]{this});
                this._eof = EOF;
                if (this._listener != null) {
                    this._channelState.onReadPossible();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAll() {
        Object object = this.lock();
        synchronized (object) {
            try {
                while (!this.isFinished()) {
                    T item = this.getNextContent();
                    if (item == null) {
                        this._state.waitForContent(this);
                        continue;
                    }
                    this.consume(item, this.remaining(item));
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock();
        synchronized (object) {
            return this._state.isEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock();
        synchronized (object) {
            if (this._listener == null) {
                return true;
            }
            int available = this.available();
            if (available > 0) {
                return true;
            }
            if (!this._notReady) {
                this._notReady = true;
                if (this._state.isEOF()) {
                    this._channelState.onReadPossible();
                } else {
                    this.unready();
                }
            }
            return false;
        }
    }

    protected void unready() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw new NullPointerException("readListener==null");
        }
        Object object = this.lock();
        synchronized (object) {
            if (this._state != BLOCKING) {
                throw new IllegalStateException("state=" + this._state);
            }
            this._state = ASYNC;
            this._listener = readListener;
            this._notReady = true;
            this._channelState.onReadPossible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable x) {
        Object object = this.lock();
        synchronized (object) {
            if (this._onError == null) {
                LOG.warn(x);
            } else {
                this._onError = x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean eof;
        boolean available;
        Throwable x;
        Object object = this.lock();
        synchronized (object) {
            T item;
            if (!this._notReady || this._listener == null) {
                return;
            }
            x = this._onError;
            try {
                item = this.getNextContent();
            }
            catch (Exception e) {
                item = null;
                this.failed(e);
            }
            available = item != null && this.remaining(item) > 0;
            eof = !available && this._state.isEOF();
            this._notReady = !available && !eof;
        }
        try {
            if (x != null) {
                this._listener.onError(x);
            } else if (available) {
                this._listener.onDataAvailable();
            } else if (eof) {
                this._listener.onAllDataRead();
            } else {
                this.unready();
            }
        }
        catch (Throwable e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
            this._listener.onError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(HttpChannelState state) {
        Object object = this.lock();
        synchronized (object) {
            this._channelState = state;
        }
    }

    protected static class State {
        protected State() {
        }

        public void waitForContent(HttpInput<?> in) throws IOException {
        }

        public int noContent() throws IOException {
            return -1;
        }

        public boolean isEOF() {
            return false;
        }
    }
}

