/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.libsvm;

import com.google.common.collect.BiMap;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.ctakes.ytex.kernel.BaseSparseDataFormatter;
import org.apache.ctakes.ytex.kernel.FileUtil;
import org.apache.ctakes.ytex.kernel.InstanceData;
import org.apache.ctakes.ytex.kernel.KernelUtil;
import org.apache.ctakes.ytex.kernel.SparseData;
import org.apache.ctakes.ytex.kernel.SparseDataFormatter;
import org.apache.ctakes.ytex.kernel.SparseDataFormatterFactory;

public class LibSVMFormatterFactory
implements SparseDataFormatterFactory {
    KernelUtil kernelUtil;

    public KernelUtil getKernelUtil() {
        return this.kernelUtil;
    }

    public void setKernelUtil(KernelUtil kernelUtil) {
        this.kernelUtil = kernelUtil;
    }

    @Override
    public SparseDataFormatter getFormatter() {
        return new LibSVMFormatter(this.getKernelUtil());
    }

    public static class LibSVMFormatter
    extends BaseSparseDataFormatter {
        @Override
        public void initializeExport(InstanceData instanceLabel, Properties properties, SparseData sparseData) throws IOException {
            super.initializeExport(instanceLabel, properties, sparseData);
        }

        public LibSVMFormatter(KernelUtil kernelUtil) {
            super(kernelUtil);
        }

        @Override
        public void initializeLabel(String label, SortedMap<Integer, SortedMap<Integer, SortedMap<Boolean, SortedMap<Long, String>>>> labelInstances, Properties properties, SparseData sparseData) throws IOException {
            this.kernelUtil.exportClassIds(this.outdir, (Map)this.labelToClassIndexMap.get(label), label);
        }

        @Override
        public void initializeFold(SparseData sparseData, String label, Integer run, Integer fold, SortedMap<Boolean, SortedMap<Long, String>> foldInstanceLabelMap) throws IOException {
            this.exportAttributeNames(sparseData, label, run, fold);
        }

        @Override
        public void exportFold(SparseData sparseData, SortedMap<Long, String> instanceClassMap, boolean train, String label, Integer run, Integer fold) throws IOException {
            String filename = FileUtil.getDataFilePrefix(this.outdir, label, run, fold, train) + "_data.txt";
            String idFilename = FileUtil.getDataFilePrefix(this.outdir, label, run, fold, train) + "_id.txt";
            this.exportDataForLabel(filename, idFilename, sparseData, instanceClassMap, (BiMap<String, Integer>)((BiMap)this.labelToClassIndexMap.get(label)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void exportDataForLabel(String filename, String idFilename, SparseData bagOfWordsData, SortedMap<Long, String> instanceClassMap, BiMap<String, Integer> classToIndexMap) throws IOException {
            BufferedWriter wData = null;
            BufferedWriter wId = null;
            try {
                wData = new BufferedWriter(new FileWriter(filename));
                wId = new BufferedWriter(new FileWriter(idFilename));
                this.exportDataForInstances(bagOfWordsData, instanceClassMap, classToIndexMap, wData, wId);
            }
            finally {
                if (wData != null) {
                    wData.close();
                }
                if (wId != null) {
                    wId.close();
                }
            }
        }

        protected List<Long> exportDataForInstances(SparseData bagOfWordsData, SortedMap<Long, String> instanceClassMap, BiMap<String, Integer> classToIndexMap, BufferedWriter wData, BufferedWriter wId) throws IOException {
            ArrayList<Long> instanceIds = new ArrayList<Long>();
            for (Map.Entry<Long, String> instanceClass : instanceClassMap.entrySet()) {
                long instanceId = instanceClass.getKey();
                instanceIds.add(instanceId);
                SortedMap<Integer, Double> instanceValues = this.getSparseLineValues(bagOfWordsData, this.numericAttributeMap, this.nominalAttributeMap, instanceId);
                int classId = (Integer)classToIndexMap.get((Object)instanceClass.getValue());
                wId.write(Long.toString(instanceId));
                wId.newLine();
                wData.write(Integer.toString(classId));
                this.writeLibsvmLine(wData, instanceValues);
            }
            return instanceIds;
        }

        protected void writeLibsvmLine(BufferedWriter wData, SortedMap<Integer, Double> instanceValues) throws IOException {
            for (Map.Entry<Integer, Double> instanceValue : instanceValues.entrySet()) {
                wData.write("\t");
                wData.write(Integer.toString(instanceValue.getKey()));
                wData.write(":");
                wData.write(Double.toString(instanceValue.getValue()));
            }
            wData.newLine();
        }

        @Override
        public void clearFold() {
            this.numericAttributeMap.clear();
            this.nominalAttributeMap.clear();
        }

        @Override
        public void clearLabel() {
        }
    }
}

