/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class ApplicationContextHolder {
    private static final Log log = LogFactory.getLog(ApplicationContextHolder.class);
    private static Properties ytexProperties;
    private static BeanFactoryLocator beanFactory;
    private static ApplicationContext ytexApplicationContext;

    public static ApplicationContext getApplicationContext() {
        return (ApplicationContext)beanFactory.useBeanFactory("ytexApplicationContext").getFactory();
    }

    public static Properties getYtexProperties() {
        return ytexProperties;
    }

    static {
        InputStream ytexPropsIn = null;
        String beanRefContext = "classpath*:org/apache/ctakes/ytex/uima/beanRefContext.xml";
        try {
            log.info((Object)("loading ytex.properties from: " + ApplicationContextHolder.class.getResource("/org/apache/ctakes/ytex/ytex.properties")));
            ytexPropsIn = ApplicationContextHolder.class.getResourceAsStream("/org/apache/ctakes/ytex/ytex.properties");
            ytexProperties = new Properties();
            ytexProperties.load(ytexPropsIn);
            ytexProperties.putAll((Map<?, ?>)System.getProperties());
            beanRefContext = ytexProperties.getProperty("ytex.beanRefContext", beanRefContext);
            if (log.isInfoEnabled()) {
                log.info((Object)("beanRefContext=" + beanRefContext));
            }
            beanFactory = ContextSingletonBeanFactoryLocator.getInstance((String)beanRefContext);
        }
        catch (Exception e) {
            log.error((Object)"initalizer", (Throwable)e);
        }
        finally {
            if (ytexPropsIn != null) {
                try {
                    ytexPropsIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

