/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.metastasis;

import com.google.common.collect.Lists;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.data.analysis.Utils;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class AnatomicalSiteListExtractorPipeline {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        CollectionReader collectionReader = Utils.getCollectionReader(options.getInputDirectory());
        AnalysisEngine listAndConjunctionAnnotator = AnalysisEngineFactory.createEngine(ListAndConjunctionAe.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{listAndConjunctionAnnotator});
    }

    public static class ListAndConjunctionAe
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                int beginOffset = -1;
                int endOffset = -1;
                State state = State.START;
                for (BaseToken input : JCasUtil.selectCovered((JCas)systemView, BaseToken.class, (AnnotationFS)sentence)) {
                    if ((state = this.getNextState(systemView, state, input)) == State.ANATSITE1) {
                        beginOffset = input.getBegin();
                        continue;
                    }
                    if (state == State.ANATSITE2) {
                        endOffset = input.getEnd();
                        continue;
                    }
                    if (state != State.ACCEPT) continue;
                    state = State.START;
                    int begin = beginOffset - sentence.getBegin();
                    int end = endOffset - sentence.getBegin();
                    System.out.println(sentence.getCoveredText());
                    System.out.println(sentence.getCoveredText().substring(begin, end));
                    System.out.println();
                }
            }
        }

        public State getNextState(JCas systemView, State currentState, BaseToken inputToken) {
            State nextState;
            HashSet listConnectors = new HashSet(Lists.newArrayList((Object[])new String[]{"and", "or", ","}));
            int tokenSemType = this.getSemanticType(systemView, inputToken);
            String tokenText = inputToken.getCoveredText().toLowerCase();
            if (currentState == State.START) {
                nextState = tokenSemType == 6 ? State.ANATSITE1 : State.START;
            } else if (currentState == State.ANATSITE1) {
                nextState = listConnectors.contains(tokenText) ? State.LISTCONN : State.START;
            } else if (currentState == State.LISTCONN) {
                nextState = tokenSemType == 6 ? State.ANATSITE2 : State.START;
            } else if (currentState == State.ANATSITE2) {
                nextState = listConnectors.contains(tokenText) ? State.LISTCONN : State.ACCEPT;
            } else {
                System.out.println("\nThis shouldn't happen!\n");
                nextState = State.START;
            }
            return nextState;
        }

        public int getSemanticType(JCas systemView, BaseToken baseToken) {
            List coveredIdentifiedAnnotations = JCasUtil.selectCovered((JCas)systemView, IdentifiedAnnotation.class, (int)baseToken.getBegin(), (int)baseToken.getEnd());
            if (coveredIdentifiedAnnotations.size() < 1) {
                return 0;
            }
            return ((IdentifiedAnnotation)coveredIdentifiedAnnotations.get(0)).getTypeID();
        }

        public static enum State {
            START,
            ANATSITE1,
            LISTCONN,
            ANATSITE2,
            ACCEPT;

        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"}, description="path to xmi files containing gold annotations")
        public File getInputDirectory();
    }
}

