/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.feature.ClosestVerbExtractor;
import org.apache.ctakes.temporal.ae.feature.ContinuousTextExtractor;
import org.apache.ctakes.temporal.ae.feature.DateAndMeasurementExtractor;
import org.apache.ctakes.temporal.ae.feature.EventPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.NearbyVerbTenseXExtractor;
import org.apache.ctakes.temporal.ae.feature.SectionHeaderExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeXExtractor;
import org.apache.ctakes.temporal.utils.SoftMaxUtil;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;

@PipeBitInfo(name="DocTimeRel Annotator", description="Annotates event relativity to document creation time.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT})
public class DocTimeRelAnnotator
extends CleartkAnnotator<String> {
    private CleartkExtractor<EventMention, BaseToken> contextExtractor;
    private CleartkExtractor<EventMention, BaseToken> tokenVectorContext;
    private CleartkExtractor<EventMention, BaseToken> tokenVectorContext2;
    private ContinuousTextExtractor continuousText;
    private ContinuousTextExtractor continuousText2;
    private SectionHeaderExtractor sectionIDExtractor;
    private ClosestVerbExtractor closestVerbExtractor;
    private TimeXExtractor timeXExtractor;
    private EventPropertyExtractor genericExtractor;
    private NearbyVerbTenseXExtractor verbTensePatternExtractor;
    private DateAndMeasurementExtractor dateExtractor;
    public static final String PARAM_PROB_VIEW = "ProbView";
    @ConfigurationParameter(name="ProbView", mandatory=false)
    private String probViewname = null;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DocTimeRelAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DocTimeRelAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    @Deprecated
    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DocTimeRelAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        CombinedExtractor1 baseExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.ONE_PER_CHAR), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.contextExtractor = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)baseExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()}), new CleartkExtractor.Following(3)});
        String vectorFile = "org/apache/ctakes/temporal/mimic_vectors.txt";
        String vectorFile2 = "org/apache/ctakes/temporal/thyme_word2vec_mapped_50.vec";
        try {
            this.continuousText = new ContinuousTextExtractor("org/apache/ctakes/temporal/mimic_vectors.txt");
            this.continuousText2 = new ContinuousTextExtractor("org/apache/ctakes/temporal/thyme_word2vec_mapped_50.vec");
        }
        catch (CleartkExtractorException e) {
            System.err.println("cannot find file: org/apache/ctakes/temporal/mimic_vectors.txt");
            e.printStackTrace();
        }
        this.tokenVectorContext = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)this.continuousText, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(5), new CleartkExtractor.Covered(), new CleartkExtractor.Following(5)});
        this.tokenVectorContext2 = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)this.continuousText2, new CleartkExtractor.Context[]{new CleartkExtractor.Covered()});
        this.sectionIDExtractor = new SectionHeaderExtractor();
        this.closestVerbExtractor = new ClosestVerbExtractor();
        this.timeXExtractor = new TimeXExtractor();
        this.genericExtractor = new EventPropertyExtractor();
        this.verbTensePatternExtractor = new NearbyVerbTenseXExtractor();
        this.dateExtractor = new DateAndMeasurementExtractor();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
            List sents = JCasUtil.selectCovering((JCas)jCas, Sentence.class, (AnnotationFS)eventMention);
            ArrayList<Feature> features = new ArrayList<Feature>();
            if (sents != null && sents.size() > 0) {
                features.addAll(this.contextExtractor.extractWithin(jCas, (Annotation)eventMention, (Annotation)sents.get(0)));
                features.addAll(this.tokenVectorContext.extractWithin(jCas, (Annotation)eventMention, (Annotation)sents.get(0)));
                features.addAll(this.tokenVectorContext2.extractWithin(jCas, (Annotation)eventMention, (Annotation)sents.get(0)));
            } else {
                features.addAll(this.contextExtractor.extract(jCas, (Annotation)eventMention));
                features.addAll(this.tokenVectorContext.extract(jCas, (Annotation)eventMention));
                features.addAll(this.tokenVectorContext2.extract(jCas, (Annotation)eventMention));
            }
            features.addAll(this.sectionIDExtractor.extract(jCas, (Annotation)eventMention));
            features.addAll(this.closestVerbExtractor.extract(jCas, (Annotation)eventMention));
            features.addAll(this.timeXExtractor.extract(jCas, (Annotation)eventMention));
            features.addAll(this.genericExtractor.extract(jCas, (Annotation)eventMention));
            features.addAll(this.verbTensePatternExtractor.extract(jCas, (Annotation)eventMention));
            features.addAll(this.dateExtractor.extract(jCas, (Annotation)eventMention));
            if (this.isTraining()) {
                if (eventMention.getEvent() == null) continue;
                String outcome = eventMention.getEvent().getProperties().getDocTimeRel();
                this.dataWriter.write(new Instance((Object)outcome, features));
                continue;
            }
            Map scores = this.classifier.score(features);
            Map.Entry maxEntry = null;
            for (Map.Entry entry : scores.entrySet()) {
                if (maxEntry != null && ((Double)entry.getValue()).compareTo((Double)maxEntry.getValue()) <= 0) continue;
                maxEntry = entry;
            }
            if (this.probViewname != null) {
                Map probs = SoftMaxUtil.getDistributionFromScores(scores);
                try {
                    JCas probView = jCas.getView(this.probViewname);
                    for (String label : probs.keySet()) {
                        EventMention mention = new EventMention(probView);
                        mention.setId(eventMention.getId());
                        mention.setConfidence(probs.get(label).floatValue());
                        Event event = new Event(probView);
                        EventProperties props = new EventProperties(probView);
                        props.setDocTimeRel(label);
                        event.setProperties(props);
                        mention.setEvent(event);
                        mention.addToIndexes();
                    }
                }
                catch (CASException e) {
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            if (eventMention.getEvent() == null) {
                Event event = new Event(jCas);
                eventMention.setEvent(event);
                EventProperties props = new EventProperties(jCas);
                event.setProperties(props);
            }
            if (maxEntry == null) continue;
            eventMention.getEvent().getProperties().setDocTimeRel((String)maxEntry.getKey());
            eventMention.getEvent().setConfidence((double)((Double)maxEntry.getValue()).floatValue());
        }
    }
}

