/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.DependencyParseUtils;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class DependencyPathFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode node1 = DependencyParseUtils.findAnnotationHead(jCas, (Annotation)arg1);
        ConllDependencyNode node2 = DependencyParseUtils.findAnnotationHead(jCas, (Annotation)arg2);
        if (node1 == null || node2 == null) {
            return features;
        }
        LinkedList<ConllDependencyNode> node1ToNode2Path = DependencyParseUtils.getPathBetweenNodes(node1, node2);
        features.add(new Feature("dependency_path", (Object)DependencyParseUtils.pathToString(node1ToNode2Path)));
        features.add(new Feature("dependency_path_length", (Object)node1ToNode2Path.size()));
        return features;
    }
}

