/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.util.ViewUriUtil;

public abstract class EvaluationOfAnnotationSpans_ImplBase
extends Evaluation_ImplBase<AnnotationStatistics<String>> {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private Class<? extends Annotation> annotationClass;

    public void setLogging(Level level, File outputFile) throws IOException {
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        this.logger.setLevel(level);
        FileHandler handler = new FileHandler(outputFile.getPath());
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + '\n';
            }
        });
        this.logger.addHandler(handler);
    }

    public EvaluationOfAnnotationSpans_ImplBase(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, Class<? extends Annotation> annotationClass) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory);
        this.annotationClass = annotationClass;
    }

    public EvaluationOfAnnotationSpans_ImplBase(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, Class<? extends Annotation> annotationClass) {
        this(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, null, annotationClass);
    }

    protected abstract AnalysisEngineDescription getDataWriterDescription(File var1) throws ResourceInitializationException;

    protected abstract void trainAndPackage(File var1) throws Exception;

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(this.annotationClass), new String[0]);
        aggregateBuilder.add(this.getDataWriterDescription(directory), new String[]{"TimexView", "_InitialView"});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        this.trainAndPackage(directory);
    }

    protected abstract AnalysisEngineDescription getAnnotatorDescription(File var1) throws ResourceInitializationException;

    protected abstract Collection<? extends Annotation> getGoldAnnotations(JCas var1, Segment var2);

    protected abstract Collection<? extends Annotation> getSystemAnnotations(JCas var1, Segment var2);

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(this.getAnnotatorDescription(directory), new String[]{"TimexView", "_InitialView"});
        if (this.i2b2Output != null) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.WriteI2B2XML.class, (Object[])new Object[]{"PARAM_OUTPUT_DIR", this.i2b2Output}), new String[]{"TimexView", "_InitialView"});
        }
        AnnotationStatistics stats = new AnnotationStatistics();
        Ordering bySpans = Ordering.natural().lexicographical().onResultOf((Function)new Function<Annotation, List<Integer>>(){

            public List<Integer> apply(Annotation annotation) {
                return Arrays.asList(annotation.getBegin(), annotation.getEnd());
            }
        });
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            this.logger.fine("Errors in : " + ViewUriUtil.getURI((JCas)jCas).toString());
            for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
                if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
                Collection<? extends Annotation> goldAnnotations = this.getGoldAnnotations(goldView, segment);
                Collection<? extends Annotation> systemAnnotations = this.getSystemAnnotations(systemView, segment);
                stats.add(goldAnnotations, systemAnnotations);
                TreeSet<Annotation> goldSet = new TreeSet<Annotation>((Comparator<Annotation>)bySpans);
                for (Annotation annotation : goldAnnotations) {
                    if (annotation.getBegin() == Integer.MAX_VALUE || annotation.getEnd() == Integer.MIN_VALUE) {
                        this.logger.warning("Invalid annotation");
                        continue;
                    }
                    goldSet.add(annotation);
                }
                TreeSet<? extends Annotation> systemSet = new TreeSet<Annotation>((Comparator<? extends Annotation>)bySpans);
                systemSet.addAll(systemAnnotations);
                TreeSet<Annotation> treeSet = new TreeSet<Annotation>((Comparator<Annotation>)bySpans);
                treeSet.addAll(goldSet);
                treeSet.removeAll(systemSet);
                TreeSet<? extends Annotation> systemOnly = new TreeSet<Annotation>((Comparator<? extends Annotation>)bySpans);
                systemOnly.addAll(systemSet);
                systemOnly.removeAll(goldSet);
                String text = jCas.getDocumentText().replaceAll("[\r\n]", " ");
                if (!treeSet.isEmpty() || !systemOnly.isEmpty()) {
                    int windowEnd;
                    int windowBegin;
                    int end;
                    int begin;
                    this.logger.fine("Errors in : " + ViewUriUtil.getURI((JCas)jCas).toString());
                    TreeSet<Object> errors = new TreeSet<Object>((Comparator<Object>)bySpans);
                    errors.addAll(treeSet);
                    errors.addAll(systemOnly);
                    for (Annotation annotation : errors) {
                        begin = annotation.getBegin();
                        end = annotation.getEnd();
                        windowBegin = Math.max(0, begin - 50);
                        windowEnd = Math.min(text.length(), end + 50);
                        String string = treeSet.contains(annotation) ? "DROPPED:" : "ADDED:  ";
                        this.logger.fine(String.format("%s  ...%s[!%s!:%d-%d]%s...", string, text.substring(windowBegin, begin), text.substring(begin, end), begin, end, text.substring(end, windowEnd)));
                    }
                    for (Annotation annotation : goldSet) {
                        if (errors.contains(annotation)) continue;
                        begin = annotation.getBegin();
                        end = annotation.getEnd();
                        windowBegin = Math.max(0, begin - 50);
                        windowEnd = Math.min(text.length(), end + 50);
                        String string = "CORRECT:";
                        this.logger.fine(String.format("%s  ...%s[!%s!:%d-%d]%s...", string, text.substring(windowBegin, begin), text.substring(begin, end), begin, end, text.substring(end, windowEnd)));
                    }
                }
                HashSet<Annotation> partialGold = new HashSet<Annotation>();
                HashSet<Annotation> partialSystem = new HashSet<Annotation>();
                if (!this.printOverlapping) continue;
                for (Annotation gold : treeSet) {
                    Annotation bestSystem = null;
                    int bestOverlap = 0;
                    for (Annotation annotation : systemOnly) {
                        int overlap;
                        if (annotation.getBegin() >= gold.getBegin() && annotation.getEnd() <= gold.getEnd()) {
                            overlap = annotation.getEnd() - annotation.getBegin();
                            if (overlap <= bestOverlap) continue;
                            bestOverlap = overlap;
                            bestSystem = annotation;
                            continue;
                        }
                        if (gold.getBegin() < annotation.getBegin() || gold.getEnd() > annotation.getEnd() || (overlap = gold.getEnd() - gold.getBegin()) <= bestOverlap) continue;
                        bestOverlap = overlap;
                        bestSystem = annotation;
                    }
                    if (bestSystem == null) continue;
                    this.logger.info(String.format("Allowed overlapping annotation: Gold(%s) => System(%s)\n", gold.getCoveredText(), bestSystem.getCoveredText()));
                    partialGold.add(gold);
                    partialSystem.add(bestSystem);
                }
                if (partialGold.size() <= 0) continue;
                treeSet.removeAll(partialGold);
                systemOnly.removeAll(partialSystem);
                assert (partialGold.size() == partialSystem.size());
                this.logger.info(String.format("Found %d overlapping spans and removed from gold/system errors\n", partialGold.size()));
            }
        }
        return stats;
    }
}

