/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ctakes.dictionary.lookup.DictionaryEngine;
import org.apache.ctakes.dictionary.lookup.ae.LookupAnnotationToJCasAdapter;
import org.apache.ctakes.dictionary.lookup.ae.LookupInitializer;
import org.apache.ctakes.dictionary.lookup.algorithms.DirectPassThroughImpl;
import org.apache.ctakes.dictionary.lookup.algorithms.LookupAlgorithm;
import org.apache.ctakes.dictionary.lookup.phrasebuilder.VariantPhraseBuilderImpl;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;

public class DirectLookupInitializerImpl
implements LookupInitializer {
    private final String CANONICAL_VARIANT_ATTR = "canonicalATTR";
    private final Logger iv_logger = Logger.getLogger((String)this.getClass().getName());

    public DirectLookupInitializerImpl(UimaContext uimaContext, Properties props) {
    }

    @Override
    public LookupAlgorithm getLookupAlgorithm(DictionaryEngine dictEngine) throws AnnotatorInitializationException {
        String[] variantArr = new String[]{"canonicalATTR"};
        VariantPhraseBuilderImpl pb = new VariantPhraseBuilderImpl(variantArr, true);
        return new DirectPassThroughImpl(dictEngine, pb);
    }

    @Override
    public Iterator<LookupToken> getLookupTokenIterator(JCas jcas) throws AnnotatorInitializationException {
        ArrayList<LookupAnnotationToJCasAdapter> ltList = new ArrayList<LookupAnnotationToJCasAdapter>();
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        AnnotationIndex annotationIndex = indexes.getAnnotationIndex(BaseToken.type);
        for (Annotation annotation : annotationIndex) {
            WordToken wta;
            String canonicalForm;
            boolean isNonLookup;
            if (!(annotation instanceof BaseToken)) {
                this.iv_logger.warn((Object)(this.getClass().getName() + " getLookupTokenIterator(..) Annotation is not a BaseToken"));
                continue;
            }
            boolean bl = isNonLookup = annotation instanceof NewlineToken || annotation instanceof PunctuationToken || annotation instanceof ContractionToken || annotation instanceof SymbolToken;
            if (isNonLookup) continue;
            BaseToken bta = (BaseToken)annotation;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter((Annotation)bta);
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute("canonicalATTR", canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList.iterator();
    }

    @Override
    public Iterator<Annotation> getLookupWindowIterator(JCas jcas) throws AnnotatorInitializationException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        return indexes.getAnnotationIndex(Sentence.type).iterator();
    }

    @Override
    public Map<String, List<LookupAnnotation>> getContextMap(JCas jcas, int windowBegin, int windowEnd) {
        return Collections.emptyMap();
    }

    @Override
    public List<LookupToken> getSortedLookupTokens(JCas jcas, Annotation annotation) throws AnnotatorInitializationException {
        ArrayList<LookupToken> ltList = new ArrayList<LookupToken>();
        List inList = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (AnnotationFS)annotation);
        for (BaseToken bta : inList) {
            WordToken wta;
            String canonicalForm;
            boolean isNonLookup;
            boolean bl = isNonLookup = bta instanceof NewlineToken || bta instanceof PunctuationToken || bta instanceof ContractionToken || bta instanceof SymbolToken;
            if (isNonLookup) continue;
            LookupAnnotationToJCasAdapter lt = new LookupAnnotationToJCasAdapter((Annotation)bta);
            if (bta instanceof WordToken && (canonicalForm = (wta = (WordToken)bta).getCanonicalForm()) != null) {
                lt.addStringAttribute("canonicalATTR", canonicalForm);
            }
            ltList.add(lt);
        }
        return ltList;
    }
}

